/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.glsp.server.registry.Registry;
import org.eclipse.glsp.server.types.GLSPServerException;

public class MapRegistry<K, V>
implements Registry<K, V> {
    protected Map<K, V> elements = new HashMap();

    @Override
    public boolean register(K key, V instance) {
        return this.elements.putIfAbsent(key, instance) == null;
    }

    @Override
    public boolean deregister(K key) {
        return this.elements.remove(key) != null;
    }

    @Override
    public boolean hasKey(K key) {
        return this.elements.containsKey(key);
    }

    @Override
    public Optional<V> get(K key) {
        return Optional.ofNullable(this.elements.get(key));
    }

    @Override
    public Set<V> getAll() {
        return new HashSet<V>(this.elements.values());
    }

    @Override
    public Set<K> keys() {
        return new HashSet<K>(this.elements.keySet());
    }

    protected GLSPServerException missing(K key) {
        return new GLSPServerException("Unknown registry key: " + String.valueOf(key));
    }
}

