/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.rewrite.imports;

import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;

public final class ImportName {
    public final boolean isStatic;
    public final boolean isModule;
    public final String containerName;
    public final String simpleName;
    public final String qualifiedName;

    static ImportName createFor(ImportDeclaration importDeclaration) {
        String declName = importDeclaration.getName().getFullyQualifiedName();
        if (Modifier.isModule(importDeclaration.getModifiers())) {
            return ImportName.createFor(importDeclaration.isStatic(), Modifier.isModule(importDeclaration.getModifiers()), declName);
        }
        if (importDeclaration.isOnDemand()) {
            return ImportName.createOnDemand(importDeclaration.isStatic(), declName);
        }
        return ImportName.createFor(importDeclaration.isStatic(), Modifier.isModule(importDeclaration.getModifiers()), declName);
    }

    static ImportName createOnDemand(boolean isStatic, String containerName) {
        return new ImportName(isStatic, false, containerName, "*");
    }

    public static ImportName createFor(boolean isStatic, boolean isModule, String qualifiedName) {
        String containerName = Signature.getQualifier(qualifiedName);
        String simpleName = Signature.getSimpleName(qualifiedName);
        return new ImportName(isStatic, isModule, containerName, simpleName);
    }

    private ImportName(boolean isStatic, boolean isModule, String containerName, String simpleName) {
        this.isStatic = isStatic;
        this.isModule = isModule;
        assert (!this.isStatic || !this.isModule);
        this.containerName = containerName;
        this.simpleName = simpleName;
        this.qualifiedName = containerName.isEmpty() ? simpleName : containerName + "." + simpleName;
    }

    public String toString() {
        String template = this.isStatic ? "staticImport(%s)" : (this.isModule ? "moduleImport(%s)" : "typeImport(%s)");
        return String.format(template, this.qualifiedName);
    }

    public int hashCode() {
        int result = this.qualifiedName.hashCode();
        result = 31 * result + (this.isStatic ? 1 : 0) + (this.isModule ? 3 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImportName)) {
            return false;
        }
        ImportName other = (ImportName)obj;
        return this.qualifiedName.equals(other.qualifiedName) && this.isStatic == other.isStatic && this.isModule == other.isModule;
    }

    public boolean isOnDemand() {
        return this.simpleName.equals("*");
    }

    ImportName getContainerOnDemand() {
        if (this.isOnDemand()) {
            return this;
        }
        return ImportName.createOnDemand(this.isStatic, this.containerName);
    }
}

