/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationEventAdapter
implements ConfigurationListener {
    public static final String TOPIC = "org/osgi/service/cm/ConfigurationEvent";
    public static final char TOPIC_SEPARATOR = '/';
    public static final String CM_UPDATED = "CM_UPDATED";
    public static final String CM_DELETED = "CM_DELETED";
    public static final String CM_FACTORY_PID = "cm.factoryPid";
    public static final String CM_PID = "cm.pid";
    public static final String SERVICE = "service";
    public static final String SERVICE_ID = "service.id";
    public static final String SERVICE_OBJECTCLASS = "service.objectClass";
    public static final String SERVICE_PID = "service.pid";
    private final BundleContext context;
    private ServiceRegistration<ConfigurationListener> configListenerRegistration;
    private final ServiceTracker<EventAdmin, EventAdmin> eventAdminTracker;

    public ConfigurationEventAdapter(BundleContext context) {
        this.context = context;
        this.eventAdminTracker = new ServiceTracker(context, EventAdmin.class, null);
    }

    public void start() throws Exception {
        this.eventAdminTracker.open();
        this.configListenerRegistration = this.context.registerService(ConfigurationListener.class, (Object)this, null);
    }

    public void stop() throws Exception {
        this.configListenerRegistration.unregister();
        this.configListenerRegistration = null;
        this.eventAdminTracker.close();
    }

    public void configurationEvent(ConfigurationEvent event) {
        EventAdmin eventAdmin = (EventAdmin)this.eventAdminTracker.getService();
        if (eventAdmin == null) {
            return;
        }
        String typename = null;
        switch (event.getType()) {
            case 1: {
                typename = CM_UPDATED;
                break;
            }
            case 2: {
                typename = CM_DELETED;
                break;
            }
            default: {
                return;
            }
        }
        String topic = "org/osgi/service/cm/ConfigurationEvent/" + typename;
        ServiceReference ref = event.getReference();
        if (ref == null) {
            throw new RuntimeException("ServiceEvent.getServiceReference() is null");
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put(CM_PID, event.getPid());
        if (event.getFactoryPid() != null) {
            properties.put(CM_FACTORY_PID, event.getFactoryPid());
        }
        this.putServiceReferenceProperties(properties, ref);
        Event convertedEvent = new Event(topic, properties);
        eventAdmin.postEvent(convertedEvent);
    }

    private void putServiceReferenceProperties(Hashtable<String, Object> properties, ServiceReference<?> ref) {
        Object o2;
        properties.put(SERVICE, ref);
        properties.put(SERVICE_ID, ref.getProperty(SERVICE_ID));
        Object o = ref.getProperty(SERVICE_PID);
        if (o != null && o instanceof String) {
            properties.put(SERVICE_PID, o);
        }
        if ((o2 = ref.getProperty("objectClass")) != null && o2 instanceof String[]) {
            properties.put(SERVICE_OBJECTCLASS, o2);
        }
    }
}

