/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.h2db.filter;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.db.H2DbService;
import org.eclipse.kura.internal.wire.h2db.common.H2DbServiceHelper;
import org.eclipse.kura.internal.wire.h2db.filter.H2DbWireRecordFilterOptions;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.wireadmin.Wire;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class H2DbWireRecordFilter
implements WireEmitter,
WireReceiver,
ConfigurableComponent {
    private static final Logger logger = LogManager.getLogger(H2DbWireRecordFilter.class);
    private List<WireRecord> lastRecords;
    private H2DbServiceHelper dbHelper;
    private H2DbWireRecordFilterOptions options;
    private volatile WireHelperService wireHelperService;
    private WireSupport wireSupport;
    private Calendar lastRefreshedTime;
    private int cacheExpirationInterval;
    private ServiceTracker<H2DbService, H2DbService> dbServiceTracker;
    private ComponentContext componentContext;

    public synchronized void bindDbService(H2DbService dbService) {
        this.dbHelper = H2DbServiceHelper.of(dbService);
    }

    public synchronized void unbindDbService(H2DbService dbService) {
        this.dbHelper = null;
    }

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating DB Wire Record Filter...");
        this.componentContext = componentContext;
        this.options = new H2DbWireRecordFilterOptions(properties);
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        this.cacheExpirationInterval = this.options.getCacheExpirationInterval();
        this.lastRefreshedTime = Calendar.getInstance();
        this.lastRefreshedTime.add(13, -this.cacheExpirationInterval);
        this.restartDbServiceTracker();
        logger.debug("Activating DB Wire Record Filter... Done");
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("Updating DB Wire Record Filter... {}", properties);
        String oldDbServicePid = this.options.getDbServiceInstancePid();
        this.options = new H2DbWireRecordFilterOptions(properties);
        if (!oldDbServicePid.equals(this.options.getDbServiceInstancePid())) {
            this.restartDbServiceTracker();
        }
        this.cacheExpirationInterval = this.options.getCacheExpirationInterval();
        this.lastRefreshedTime = Calendar.getInstance();
        this.lastRefreshedTime.add(13, -this.cacheExpirationInterval);
        logger.debug("Updating DB Wire Record Filter... Done");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Dectivating DB Wire Record Filter...");
        logger.debug("Dectivating DB Wire Record Filter... Done");
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    private List<WireRecord> performSQLQuery() throws SQLException {
        String sqlView = this.options.getSqlView();
        return (List)this.dbHelper.withConnection(c -> {
            ArrayList<WireRecord> dataRecords;
            block14: {
                dataRecords = new ArrayList<WireRecord>();
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    Statement stmt = c.createStatement();
                    try {
                        try (ResultSet rset = stmt.executeQuery(sqlView);){
                            while (rset.next()) {
                                WireRecord wireRecord = new WireRecord(this.convertSQLRowToWireRecord(rset));
                                dataRecords.add(wireRecord);
                            }
                        }
                        if (stmt == null) break block14;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stmt == null) throw throwable;
                        stmt.close();
                        throw throwable;
                    }
                    stmt.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            logger.debug("Refreshed typed values");
            return dataRecords;
        });
    }

    private Map<String, TypedValue<?>> convertSQLRowToWireRecord(ResultSet rset) throws SQLException {
        HashMap wireRecordProperties = new HashMap();
        ResultSetMetaData rmet = rset.getMetaData();
        int i = 1;
        while (i <= rmet.getColumnCount()) {
            String fieldName = rmet.getColumnLabel(i);
            Object dbExtractedData = rset.getObject(i);
            if (Objects.isNull(fieldName)) {
                fieldName = rmet.getColumnName(i);
            }
            if (!Objects.isNull(dbExtractedData)) {
                if (dbExtractedData instanceof Blob) {
                    Blob dbExtractedBlob = (Blob)dbExtractedData;
                    int dbExtractedBlobLength = (int)dbExtractedBlob.length();
                    dbExtractedData = dbExtractedBlob.getBytes(1L, dbExtractedBlobLength);
                }
                TypedValue value = TypedValues.newTypedValue((Object)dbExtractedData);
                wireRecordProperties.put(fieldName, value);
            }
            ++i;
        }
        return wireRecordProperties;
    }

    public synchronized void onWireReceive(WireEnvelope wireEnvelope) {
        List<Object> result;
        Objects.requireNonNull(wireEnvelope, "Wire Envelope cannot be null");
        if (this.dbHelper == null) {
            logger.warn("H2DbService instance not attached");
            return;
        }
        if (this.isCacheExpired() && this.dbHelper != null) {
            this.refreshCachedRecords();
        }
        if (!(result = Objects.nonNull(this.lastRecords) ? Collections.unmodifiableList(this.lastRecords) : Collections.unmodifiableList(new ArrayList())).isEmpty() || this.options.emitOnEmptyResult()) {
            this.wireSupport.emit(result);
        }
    }

    private void refreshCachedRecords() {
        try {
            List<WireRecord> tmpWireRecords = this.performSQLQuery();
            this.lastRecords = tmpWireRecords;
            this.lastRefreshedTime = Calendar.getInstance(this.lastRefreshedTime.getTimeZone());
        }
        catch (SQLException e) {
            logger.error("Error while filtering Wire Records...", (Throwable)e);
        }
    }

    protected void restartDbServiceTracker() {
        this.stopDbServiceTracker();
        try {
            Filter filter = FrameworkUtil.createFilter((String)("(kura.service.pid=" + this.options.getDbServiceInstancePid() + ")"));
            this.dbServiceTracker = new ServiceTracker(this.componentContext.getBundleContext(), filter, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<H2DbService, H2DbService>(){

                public H2DbService addingService(ServiceReference<H2DbService> reference) {
                    logger.info("H2DbService instance found");
                    H2DbService dbService = (H2DbService)H2DbWireRecordFilter.this.componentContext.getBundleContext().getService(reference);
                    H2DbWireRecordFilter.this.bindDbService(dbService);
                    return dbService;
                }

                public void modifiedService(ServiceReference<H2DbService> reference, H2DbService service) {
                }

                public void removedService(ServiceReference<H2DbService> reference, H2DbService service) {
                    logger.info("H2DbService instance removed");
                    H2DbWireRecordFilter.this.unbindDbService(service);
                    H2DbWireRecordFilter.this.componentContext.getBundleContext().ungetService(reference);
                }
            });
            this.dbServiceTracker.open();
        }
        catch (InvalidSyntaxException e) {
            throw new ComponentException((Throwable)e);
        }
    }

    private void stopDbServiceTracker() {
        if (this.dbServiceTracker != null) {
            this.dbServiceTracker.close();
            this.dbServiceTracker = null;
        }
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    private boolean isCacheExpired() {
        Calendar now = Calendar.getInstance();
        Calendar nextRefreshTime = Calendar.getInstance(this.lastRefreshedTime.getTimeZone());
        nextRefreshTime.setTime(this.lastRefreshedTime.getTime());
        nextRefreshTime.add(13, this.cacheExpirationInterval);
        return !nextRefreshTime.after(now);
    }
}

