/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.hook;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.kura.deployment.hook.DeploymentHook;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentHookManager {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentHookManager.class);
    private final Map<String, DeploymentHook> registeredHooks = new HashMap<String, DeploymentHook>();
    private final Map<String, HookAssociation> associations = new HashMap<String, HookAssociation>();
    private BundleContext bundleContext;

    public synchronized void bindHook(ServiceReference<DeploymentHook> hook) {
        Object rawHookId = hook.getProperty("kura.service.pid");
        if (!(rawHookId instanceof String)) {
            logger.warn("Found hook with invalid {}, not registering", (Object)"kura.service.pid");
            return;
        }
        String hookId = (String)rawHookId;
        if (this.registeredHooks.containsKey(hookId)) {
            logger.warn("Found duplicated hook with id {}, not registering", (Object)"kura.service.pid");
            return;
        }
        this.registeredHooks.put(hookId, (DeploymentHook)this.getBundleContext().getService(hook));
        logger.info("Hook registered: {}", (Object)hookId);
        this.updateAssociations();
    }

    public synchronized void unbindHook(ServiceReference<DeploymentHook> hook) {
        Object rawHookId = hook.getProperty("kura.service.pid");
        if (!(rawHookId instanceof String)) {
            return;
        }
        String hookId = (String)rawHookId;
        DeploymentHook removedHook = this.registeredHooks.remove(hookId);
        this.updateAssociations();
        if (removedHook != null) {
            this.getBundleContext().ungetService(hook);
            logger.info("Hook unregistered: {}", (Object)hookId);
        }
    }

    private BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            this.bundleContext = FrameworkUtil.getBundle(DeploymentHookManager.class).getBundleContext();
        }
        return this.bundleContext;
    }

    public synchronized void updateAssociations(Properties properties) {
        this.associations.clear();
        if (properties == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            String type = entry.getKey().toString();
            String hookId = value.toString();
            HookAssociation association = new HookAssociation(type, hookId);
            this.associations.put(type, association);
            logger.info("Association added: {}", (Object)association);
        }
        this.updateAssociations();
    }

    private void updateAssociations() {
        for (HookAssociation association : this.associations.values()) {
            DeploymentHook hook = this.registeredHooks.get(association.hookId);
            association.hook = hook;
            logger.info("Association updated: {}", (Object)association);
        }
    }

    public synchronized DeploymentHook getHook(String type) {
        HookAssociation association = this.associations.get(type);
        if (association == null) {
            return null;
        }
        return association.hook;
    }

    public Map<String, HookAssociation> getHookAssociations() {
        return Collections.unmodifiableMap(this.associations);
    }

    public Map<String, DeploymentHook> getRegisteredHooks() {
        return Collections.unmodifiableMap(this.registeredHooks);
    }

    public static class HookAssociation {
        private String type;
        private String hookId;
        private DeploymentHook hook;

        public HookAssociation(String type, String hookId) {
            this.type = type;
            this.hookId = hookId;
        }

        public String getRequestType() {
            return this.type;
        }

        public String getHookId() {
            return this.hookId;
        }

        public DeploymentHook getDeploymentHook() {
            return this.hook;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("request type: ").append(this.type).append(" hook id: ").append(this.hookId).append(" status: ").append(this.hook == null ? "NOT BOUND" : "BOUND");
            return builder.toString();
        }
    }
}

