/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.ServicesAnchorListItem;
import org.eclipse.kura.web.client.ui.ServicesUi;
import org.eclipse.kura.web.client.ui.cloudconnection.CloudConnectionsUi;
import org.eclipse.kura.web.client.ui.device.DevicePanelUi;
import org.eclipse.kura.web.client.ui.drivers.assets.DriversAndAssetsUi;
import org.eclipse.kura.web.client.ui.firewall.FirewallPanelUi;
import org.eclipse.kura.web.client.ui.network.NetworkPanelUi;
import org.eclipse.kura.web.client.ui.packages.PackagesPanelUi;
import org.eclipse.kura.web.client.ui.settings.SettingsPanelUi;
import org.eclipse.kura.web.client.ui.status.StatusPanelUi;
import org.eclipse.kura.web.client.ui.wires.WiresPanelUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.client.util.FilterBuilder;
import org.eclipse.kura.web.client.util.PidTextBox;
import org.eclipse.kura.web.client.util.request.RequestQueue;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtComponentService;
import org.eclipse.kura.web.shared.service.GwtComponentServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Column;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.ModalHeader;
import org.gwtbootstrap3.client.ui.NavPills;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.IconSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Strong;

public class EntryClassUi
extends Composite {
    @UiField
    static Modal errorModal;
    @UiField
    Label footerLeft;
    @UiField
    Row footerCenterRow;
    @UiField
    Label footerCenter;
    @UiField
    Label footerRight;
    @UiField
    Panel contentPanel;
    @UiField
    Strong errorAlertText;
    @UiField
    PanelHeader contentPanelHeader;
    @UiField
    PanelBody contentPanelBody;
    @UiField
    TabListItem status;
    @UiField
    AnchorListItem device;
    @UiField
    AnchorListItem network;
    @UiField
    AnchorListItem firewall;
    @UiField
    AnchorListItem packages;
    @UiField
    AnchorListItem settings;
    @UiField
    AnchorListItem wires;
    @UiField
    AnchorListItem cloudServices;
    @UiField
    AnchorListItem driversAndAssetsServices;
    @UiField
    ScrollPanel servicesPanel;
    @UiField
    TextBox textSearch;
    @UiField
    NavPills servicesMenu;
    @UiField
    Panel stackTraceContainer;
    @UiField
    Anchor errorStackTraceAreaOneAnchor;
    @UiField
    VerticalPanel errorStackTraceAreaOne;
    @UiField
    Modal errorPopup;
    @UiField
    Label errorMessage;
    @UiField
    Modal newFactoryComponentModal;
    @UiField
    FormLabel newFactoryComponentFormLabel;
    @UiField
    FormLabel componentInstanceNameLabel;
    @UiField
    Button buttonNewComponent;
    @UiField
    Button buttonNewComponentCancel;
    @UiField
    Button errorModalDismiss;
    @UiField
    ListBox factoriesList;
    @UiField
    Button factoriesButton;
    @UiField
    PidTextBox componentName;
    @UiField
    Button sidenavButton;
    @UiField
    Column sidenav;
    @UiField
    Panel sidenavOverlay;
    @UiField
    Label serviceDescription;
    private static final Messages MSGS;
    private static final EntryClassUIUiBinder uiBinder;
    private static final String SELECT_COMPONENT;
    private static final String SIDENAV_HIDDEN_STYLE_NAME = "sidenav-hidden";
    private static final String SELECTED_ANCHOR_LIST_ITEM_STYLE_NAME = "selected-item";
    private static final String NOT_SCROLLABLE_STYLE_NAME = "not-scrollable";
    private static final String SERVICES_FILTER;
    private static PopupPanel waitModal;
    private final StatusPanelUi statusBinder = (StatusPanelUi)((Object)GWT.create(StatusPanelUi.class));
    private final DevicePanelUi deviceBinder = (DevicePanelUi)((Object)GWT.create(DevicePanelUi.class));
    private final PackagesPanelUi packagesBinder = (PackagesPanelUi)((Object)GWT.create(PackagesPanelUi.class));
    private final SettingsPanelUi settingsBinder = (SettingsPanelUi)((Object)GWT.create(SettingsPanelUi.class));
    private final FirewallPanelUi firewallBinder = (FirewallPanelUi)((Object)GWT.create(FirewallPanelUi.class));
    private final NetworkPanelUi networkBinder = (NetworkPanelUi)((Object)GWT.create(NetworkPanelUi.class));
    private final CloudConnectionsUi cloudServicesBinder = (CloudConnectionsUi)((Object)GWT.create(CloudConnectionsUi.class));
    private final WiresPanelUi wiresBinder = (WiresPanelUi)GWT.create(WiresPanelUi.class);
    private final DriversAndAssetsUi driversAndTwinsBinder = (DriversAndAssetsUi)GWT.create(DriversAndAssetsUi.class);
    private final GwtComponentServiceAsync gwtComponentService = (GwtComponentServiceAsync)GWT.create(GwtComponentService.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final KeyUpHandler searchBoxChangeHandler = event -> {
        TextBox searchBox = (TextBox)event.getSource();
        String searchedValue = searchBox.getValue();
        if (searchedValue != null) {
            this.filterAvailableServices(searchedValue);
        }
    };
    private final EntryClassUi ui = this;
    private GwtSession currentSession;
    private GwtConfigComponent selected = null;
    private Modal modal;
    private ServicesUi servicesUi;
    private AnchorListItem selectedAnchorListItem;

    static {
        MSGS = (Messages)GWT.create(Messages.class);
        uiBinder = (EntryClassUIUiBinder)GWT.create(EntryClassUIUiBinder.class);
        SELECT_COMPONENT = MSGS.servicesComponentFactorySelectorIdle();
        SERVICES_FILTER = FilterBuilder.of(FilterBuilder.not(FilterBuilder.or("service.pid=*SystemPropertiesService", "service.pid=*NetworkAdminService", "service.pid=*NetworkConfigurationService", "service.pid=*SslManagerService", "service.pid=*FirewallConfigurationService", "service.pid=*WireGraphService", "objectClass=org.eclipse.kura.wire.WireComponent", "objectClass=org.eclipse.kura.driver.Driver", "kura.ui.service.hide=true")));
    }

    public EntryClassUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        EntryClassUi.initWaitModal();
        this.initNewComponentErrorModal();
        this.initExceptionReportModal();
        this.contentPanelHeader.setId("contentPanelHeader");
        Date now = new Date();
        int year = now.getYear() + 1900;
        this.footerLeft.setText(MSGS.copyright(String.valueOf(year)));
        this.footerLeft.setStyleName("copyright");
        this.contentPanel.setVisible(false);
        this.sidenavButton.addClickHandler(event -> {
            if (this.sidenav.getStyleName().contains(SIDENAV_HIDDEN_STYLE_NAME)) {
                this.showSidenav();
            } else {
                this.hideSidenav();
            }
        });
        this.initServicesTree();
    }

    private void initExceptionReportModal() {
        this.errorPopup.setTitle(MSGS.warning());
        this.errorStackTraceAreaOneAnchor.setText(MSGS.showStackTrace());
        FailureHandler.setPopup(this.errorPopup, this.errorMessage, this.errorStackTraceAreaOne, this.stackTraceContainer);
    }

    public void setSelectedAnchorListItem(AnchorListItem selected) {
        if (this.selectedAnchorListItem != null) {
            this.selectedAnchorListItem.removeStyleName(SELECTED_ANCHOR_LIST_ITEM_STYLE_NAME);
        }
        this.selectedAnchorListItem = selected;
        this.selectedAnchorListItem.addStyleName(SELECTED_ANCHOR_LIST_ITEM_STYLE_NAME);
        this.hideSidenav();
    }

    private void showSidenav() {
        this.sidenav.removeStyleName(SIDENAV_HIDDEN_STYLE_NAME);
        this.sidenavOverlay.removeStyleName(SIDENAV_HIDDEN_STYLE_NAME);
        RootPanel.get().addStyleName(NOT_SCROLLABLE_STYLE_NAME);
    }

    private void hideSidenav() {
        this.sidenav.addStyleName(SIDENAV_HIDDEN_STYLE_NAME);
        this.sidenavOverlay.addStyleName(SIDENAV_HIDDEN_STYLE_NAME);
        RootPanel.get().removeStyleName(NOT_SCROLLABLE_STYLE_NAME);
    }

    public void setSession(GwtSession gwtSession) {
        this.currentSession = gwtSession;
    }

    public void setFooter(GwtSession gwtSession) {
        this.footerRight.setText(gwtSession.getKuraVersion());
        this.footerCenterRow.setVisible(false);
        if (gwtSession.isDevelopMode()) {
            this.footerCenter.setText(MSGS.developmentMode());
            this.footerCenterRow.setVisible(true);
        }
    }

    public void initSystemPanel(GwtSession gwtSession) {
        EntryClassUi instanceReference = this;
        if (!gwtSession.isNetAdminAvailable()) {
            this.network.setVisible(false);
            this.firewall.setVisible(false);
        }
        this.initStatusPanel(instanceReference);
        this.initDevicePanel();
        this.initNetworkPanel();
        this.initFirewallPanel();
        this.initPackagesPanel();
        this.initSettingsPanel();
        this.initCloudServicesPanel();
        this.initWiresPanel();
        this.initDriversAndAssetsPanel();
    }

    private void initDriversAndAssetsPanel() {
        this.driversAndAssetsServices.addClickHandler(event -> {
            Button b = new Button(MSGS.yesButton(), event1 -> {
                this.forceTabsCleaning();
                if (this.modal != null) {
                    this.modal.hide();
                }
                this.setSelectedAnchorListItem(this.driversAndAssetsServices);
                this.contentPanel.setVisible(true);
                this.setHeader(MSGS.driversAndAssetsServices(), null);
                this.contentPanelBody.clear();
                this.contentPanelBody.add((Widget)this.driversAndTwinsBinder);
                this.driversAndTwinsBinder.refresh();
            });
            this.renderDirtyConfigModal(b);
        });
    }

    private void initWiresPanel() {
        this.wires.addClickHandler(event -> {
            Button b = new Button(MSGS.yesButton(), event1 -> {
                this.forceTabsCleaning();
                if (this.modal != null) {
                    this.modal.hide();
                }
                this.setSelectedAnchorListItem(this.wires);
                this.contentPanel.setVisible(true);
                this.setHeader(MSGS.wires(), null);
                this.contentPanelBody.clear();
                this.contentPanelBody.add((Widget)this.wiresBinder);
                this.wiresBinder.load();
            });
            this.renderDirtyConfigModal(b);
        });
    }

    private void initCloudServicesPanel() {
        this.cloudServices.addClickHandler(event -> {
            Button b = new Button(MSGS.yesButton(), event1 -> {
                this.forceTabsCleaning();
                if (this.modal != null) {
                    this.modal.hide();
                }
                this.setSelectedAnchorListItem(this.cloudServices);
                this.contentPanel.setVisible(true);
                this.setHeader(MSGS.cloudServices(), null);
                this.contentPanelBody.clear();
                this.contentPanelBody.add((Widget)this.cloudServicesBinder);
                this.cloudServicesBinder.refresh();
            });
            this.renderDirtyConfigModal(b);
        });
    }

    private void initSettingsPanel() {
        this.settings.addClickHandler(event -> {
            Button b = new Button(MSGS.yesButton(), event1 -> {
                this.forceTabsCleaning();
                if (this.modal != null) {
                    this.modal.hide();
                }
                this.setSelectedAnchorListItem(this.settings);
                this.contentPanel.setVisible(true);
                this.setHeader(MSGS.settings(), null);
                this.contentPanelBody.clear();
                this.contentPanelBody.add((Widget)this.settingsBinder);
                this.settingsBinder.setSession(this.currentSession);
                this.settingsBinder.load();
            });
            this.renderDirtyConfigModal(b);
        });
    }

    private void initPackagesPanel() {
        this.packages.addClickHandler(event -> {
            Button b = new Button(MSGS.yesButton(), event1 -> {
                this.forceTabsCleaning();
                if (this.modal != null) {
                    this.modal.hide();
                }
                this.setSelectedAnchorListItem(this.packages);
                this.contentPanel.setVisible(true);
                this.setHeader(MSGS.packages(), null);
                this.contentPanelBody.clear();
                this.contentPanelBody.add((Widget)this.packagesBinder);
                this.packagesBinder.setSession(this.currentSession);
                this.packagesBinder.setMainUi(this.ui);
                this.packagesBinder.refresh();
            });
            this.renderDirtyConfigModal(b);
        });
    }

    private void initFirewallPanel() {
        if (this.firewall.isVisible()) {
            this.firewall.addClickHandler(event -> {
                Button b = new Button(MSGS.yesButton(), event1 -> {
                    this.forceTabsCleaning();
                    if (this.modal != null) {
                        this.modal.hide();
                    }
                    this.setSelectedAnchorListItem(this.firewall);
                    this.contentPanel.setVisible(true);
                    this.setHeader(MSGS.firewall(), null);
                    this.contentPanelBody.clear();
                    this.contentPanelBody.add((Widget)this.firewallBinder);
                    this.firewallBinder.initFirewallPanel();
                });
                this.renderDirtyConfigModal(b);
            });
        }
    }

    private void initNetworkPanel() {
        if (this.network.isVisible()) {
            this.network.addClickHandler(event -> {
                Button b = new Button(MSGS.yesButton(), event1 -> {
                    this.forceTabsCleaning();
                    if (this.modal != null) {
                        this.modal.hide();
                    }
                    this.setSelectedAnchorListItem(this.network);
                    this.contentPanel.setVisible(true);
                    this.setHeader(MSGS.network(), null);
                    this.contentPanelBody.clear();
                    this.contentPanelBody.add((Widget)this.networkBinder);
                    this.networkBinder.setSession(this.currentSession);
                    this.networkBinder.initNetworkPanel();
                });
                this.renderDirtyConfigModal(b);
            });
        }
    }

    private void initDevicePanel() {
        this.device.addClickHandler(event -> {
            Button b = new Button(MSGS.yesButton(), event1 -> {
                this.forceTabsCleaning();
                if (this.modal != null) {
                    this.modal.hide();
                }
                this.setSelectedAnchorListItem(this.device);
                this.contentPanel.setVisible(true);
                this.setHeader(MSGS.device(), null);
                this.contentPanelBody.clear();
                this.contentPanelBody.add((Widget)this.deviceBinder);
                this.deviceBinder.setSession(this.currentSession);
                this.deviceBinder.initDevicePanel();
            });
            this.renderDirtyConfigModal(b);
        });
    }

    private void initStatusPanel(EntryClassUi instanceReference) {
        this.status.addClickHandler(event -> {
            Button b = new Button(MSGS.yesButton(), event1 -> {
                this.forceTabsCleaning();
                if (this.modal != null) {
                    this.modal.hide();
                }
                this.setSelectedAnchorListItem((AnchorListItem)this.status);
                this.contentPanel.setVisible(true);
                this.setHeader("Status", null);
                this.contentPanelBody.clear();
                this.contentPanelBody.add((Widget)this.statusBinder);
                this.statusBinder.setSession(this.currentSession);
                this.statusBinder.setParent(instanceReference);
                this.statusBinder.loadStatusData();
            });
            this.renderDirtyConfigModal(b);
        });
    }

    private void filterAvailableServices(String serviceName) {
        if (serviceName == null) {
            this.showAllServices();
            return;
        }
        String tmpServiceName = serviceName.toLowerCase();
        if (tmpServiceName.isEmpty() || "".equals(tmpServiceName)) {
            this.showAllServices();
        } else {
            this.filterByServiceName(tmpServiceName);
        }
    }

    private void showAllServices() {
        int i = 0;
        while (i < this.servicesMenu.getWidgetCount()) {
            ServicesAnchorListItem sl = (ServicesAnchorListItem)this.servicesMenu.getWidget(i);
            sl.setVisible(true);
            ++i;
        }
    }

    private void filterByServiceName(String tmpServiceName) {
        int i = 0;
        while (i < this.servicesMenu.getWidgetCount()) {
            ServicesAnchorListItem sl = (ServicesAnchorListItem)this.servicesMenu.getWidget(i);
            sl.setVisible(tmpServiceName == null || sl.getServiceName().toLowerCase().indexOf(tmpServiceName) != -1);
            ++i;
        }
    }

    private void sortConfigurationsByName(List<GwtConfigComponent> configs) {
        Collections.sort(configs, (arg0, arg1) -> {
            String pid0 = arg0.getComponentId();
            String pid1 = arg1.getComponentId();
            int start = pid0.lastIndexOf(46);
            int substringIndex = start + 1;
            String name0 = start != -1 && substringIndex < pid0.length() ? pid0.substring(substringIndex) : pid0;
            start = pid1.lastIndexOf(46);
            substringIndex = start + 1;
            String name1 = start != -1 && substringIndex < pid1.length() ? pid1.substring(substringIndex) : pid1;
            return name0.compareTo(name1);
        });
    }

    public void fetchAvailableServices(final AsyncCallback<Void> callback) {
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                FailureHandler.handle(ex, EntryClassUi.class.getName());
            }

            public void onSuccess(GwtXSRFToken token) {
                EntryClassUi.this.gwtComponentService.findComponentConfigurations(token, SERVICES_FILTER, new AsyncCallback<List<GwtConfigComponent>>(){

                    public void onFailure(Throwable ex) {
                        FailureHandler.handle(ex, EntryClassUi.class.getName());
                        if (callback != null) {
                            callback.onFailure(ex);
                        }
                    }

                    public void onSuccess(List<GwtConfigComponent> result) {
                        EntryClassUi.this.sortConfigurationsByName(result);
                        (this).EntryClassUi.this.servicesMenu.clear();
                        for (GwtConfigComponent pair : result) {
                            if (pair.isWireComponent()) continue;
                            (this).EntryClassUi.this.servicesMenu.add((Widget)new ServicesAnchorListItem(pair, EntryClassUi.this.ui));
                        }
                        EntryClassUi.this.filterAvailableServices((this).EntryClassUi.this.textSearch.getValue());
                        if (callback != null) {
                            callback.onSuccess(null);
                        }
                    }
                });
            }
        });
    }

    private void initServicesTree() {
        this.textSearch.addKeyUpHandler(this.searchBoxChangeHandler);
        this.initNewFactoryComponentModal();
        this.factoriesButton.addClickHandler(event -> {
            this.componentName.setValue("");
            this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                public void onFailure(Throwable ex) {
                    FailureHandler.handle(ex, EntryClassUi.class.getName());
                }

                public void onSuccess(GwtXSRFToken token) {
                    EntryClassUi.this.gwtComponentService.findFactoryComponents(token, new AsyncCallback<List<String>>(){

                        public void onFailure(Throwable ex) {
                            FailureHandler.handle(ex, EntryClassUi.class.getName());
                        }

                        public void onSuccess(List<String> result) {
                            (this).EntryClassUi.this.factoriesList.clear();
                            (this).EntryClassUi.this.factoriesList.addItem(SELECT_COMPONENT);
                            for (String servicePid : result) {
                                (this).EntryClassUi.this.factoriesList.addItem(servicePid);
                            }
                            (this).EntryClassUi.this.newFactoryComponentModal.show();
                        }
                    });
                }
            });
        });
    }

    private void initNewFactoryComponentModal() {
        this.newFactoryComponentModal.setTitle(MSGS.servicesComponentFactoryNew());
        this.newFactoryComponentFormLabel.setText(MSGS.servicesComponentFactoryFactory());
        this.componentInstanceNameLabel.setText(MSGS.servicesComponentFactoryName());
        this.componentName.setPlaceholder(MSGS.servicesComponentFactoryNamePlaceholder());
        this.buttonNewComponent.setText(MSGS.submitButton());
        this.buttonNewComponentCancel.setText(MSGS.cancelButton());
        this.buttonNewComponent.addClickHandler(event -> {
            String factoryPid = this.factoriesList.getSelectedValue();
            String pid = this.componentName.getPid();
            if (pid == null) {
                return;
            }
            if (SELECT_COMPONENT.equalsIgnoreCase(factoryPid) || "".equals(pid)) {
                this.errorAlertText.setText(MSGS.servicesComponentFactoryAlertNotSelected());
                errorModal.show();
                return;
            }
            RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> {
                this.newFactoryComponentModal.hide();
                this.gwtComponentService.createFactoryComponent((GwtXSRFToken)token, factoryPid, pid, context.callback(new AsyncCallback<Void>(){

                    public void onFailure(Throwable ex) {
                        FailureHandler.showErrorMessage(MSGS.errorCreatingFactoryComponent());
                    }

                    public void onSuccess(Void result) {
                        context.defer(2000, () -> EntryClassUi.this.fetchAvailableServices(null));
                    }
                }));
            })));
        });
    }

    private void setHeader(String title, String subTitle) {
        this.contentPanelHeader.setText(title);
        this.serviceDescription.setText(subTitle != null ? subTitle : "");
    }

    public void render(GwtConfigComponent item) {
        this.contentPanelBody.clear();
        this.servicesUi = new ServicesUi(item, this);
        this.contentPanel.setVisible(true);
        if (item != null) {
            this.setHeader(item.getComponentName(), item.getComponentDescription());
        }
        this.contentPanelBody.add((Widget)this.servicesUi);
    }

    private void renderDirtyConfigModal(Button b) {
        boolean isUiDirty = this.isServicesUiDirty() || this.isNetworkDirty();
        isUiDirty = isUiDirty || this.isFirewallDirty() || this.isSettingsDirty();
        isUiDirty = isUiDirty || this.isCloudServicesDirty() || this.isWiresDirty();
        boolean bl = isUiDirty = isUiDirty || this.isDriversAndTwinsDirty();
        if (isUiDirty) {
            this.modal = new Modal();
            ModalHeader header = new ModalHeader();
            header.setTitle(MSGS.warning());
            this.modal.add((Widget)header);
            ModalBody body = new ModalBody();
            body.add((Widget)new Span(MSGS.deviceConfigDirty()));
            this.modal.add((Widget)body);
            ModalFooter footer = new ModalFooter();
            Button no = new Button();
            no.setText(MSGS.noButton());
            no.addStyleName("fa fa-times");
            no.addClickHandler(event -> this.modal.hide());
            footer.add((Widget)no);
            b.addStyleName("fa fa-check");
            footer.add((Widget)b);
            this.modal.add((Widget)footer);
            this.modal.show();
            no.setFocus(true);
        } else {
            b.click();
        }
    }

    public boolean isServicesUiDirty() {
        if (this.servicesUi != null) {
            return this.servicesUi.isDirty();
        }
        return false;
    }

    public boolean isNetworkDirty() {
        if (this.network.isVisible()) {
            return this.networkBinder.isDirty();
        }
        return false;
    }

    public boolean isFirewallDirty() {
        if (this.firewall.isVisible()) {
            return this.firewallBinder.isDirty();
        }
        return false;
    }

    public boolean isSettingsDirty() {
        if (this.settings.isVisible()) {
            return this.settingsBinder.isDirty();
        }
        return false;
    }

    public boolean isCloudServicesDirty() {
        if (this.cloudServices.isVisible()) {
            return this.cloudServicesBinder.isDirty();
        }
        return false;
    }

    public boolean isWiresDirty() {
        if (this.wires.isVisible()) {
            return this.wiresBinder.isDirty();
        }
        return false;
    }

    public boolean isDriversAndTwinsDirty() {
        if (this.driversAndTwinsBinder.isVisible()) {
            return this.driversAndTwinsBinder.isDirty();
        }
        return false;
    }

    public void setDirty() {
        if (this.servicesUi != null) {
            this.servicesUi.setDirty(false);
        }
        if (this.network.isVisible()) {
            this.networkBinder.setDirty(false);
        }
        if (this.firewall.isVisible()) {
            this.firewallBinder.setDirty(false);
        }
        if (this.settings.isVisible()) {
            this.settingsBinder.setDirty(false);
        }
        if (this.driversAndTwinsBinder.isVisible()) {
            this.driversAndTwinsBinder.clearDirtyState();
        }
    }

    private static void initWaitModal() {
        waitModal = new PopupPanel(false, true);
        Icon icon = new Icon();
        icon.setId("cog");
        icon.setType(IconType.COG);
        icon.setSize(IconSize.TIMES4);
        icon.setSpin(true);
        waitModal.setWidget((Widget)icon);
        waitModal.setGlassEnabled(true);
        waitModal.center();
        waitModal.hide();
    }

    private void initNewComponentErrorModal() {
        this.errorModalDismiss.setText(MSGS.closeButton());
    }

    public static void showWaitModal() {
        waitModal.show();
    }

    public static void hideWaitModal() {
        waitModal.hide();
    }

    private void forceTabsCleaning() {
        if (this.servicesUi != null) {
            this.servicesUi.setDirty(false);
        }
        if (this.network.isVisible()) {
            this.networkBinder.setDirty(false);
        }
        if (this.firewall.isVisible()) {
            this.firewallBinder.setDirty(false);
        }
        if (this.settings.isVisible()) {
            this.settingsBinder.setDirty(false);
        }
        if (this.cloudServices.isVisible()) {
            this.cloudServicesBinder.setDirty(false);
        }
        if (this.wires.isVisible()) {
            this.wiresBinder.clearDirtyState();
            this.wiresBinder.unload();
        }
    }

    GwtConfigComponent getSelected() {
        return this.selected;
    }

    void setSelected(GwtConfigComponent selected) {
        this.selected = selected;
    }

    public void init() {
        this.fetchAvailableServices(new AsyncCallback<Void>(){

            public void onSuccess(Void result) {
                EntryClassUi.this.showStatusPanel();
            }

            public void onFailure(Throwable caught) {
                EntryClassUi.this.showStatusPanel();
            }
        });
    }

    private void showStatusPanel() {
        this.setSelectedAnchorListItem((AnchorListItem)this.status);
        this.contentPanel.setVisible(true);
        this.contentPanelHeader.setText("Status");
        this.contentPanelBody.clear();
        this.contentPanelBody.add((Widget)this.statusBinder);
        this.statusBinder.setSession(this.currentSession);
        this.statusBinder.setParent(this);
        this.statusBinder.loadStatusData();
    }

    static interface EntryClassUIUiBinder
    extends UiBinder<Widget, EntryClassUi> {
    }
}

