/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.drivers.assets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.configuration.Configurations;
import org.eclipse.kura.web.client.configuration.HasConfiguration;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.AlertDialog;
import org.eclipse.kura.web.client.ui.drivers.assets.AssetConfigurationUi;
import org.eclipse.kura.web.client.ui.drivers.assets.AssetDataUi;
import org.eclipse.kura.web.client.ui.drivers.assets.AssetModelImpl;
import org.eclipse.kura.web.client.ui.drivers.assets.ConfigurationUiButtons;
import org.eclipse.kura.web.client.ui.drivers.assets.DriversAndAssetsRPC;
import org.eclipse.kura.web.shared.AssetConstants;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;

public class AssetMgmtUi
extends Composite {
    private static AssetMgmtUiUiBinder uiBinder = (AssetMgmtUiUiBinder)GWT.create(AssetMgmtUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private AssetConfigurationUi assetConfigUi;
    private AssetDataUi assetDataUi;
    @UiField
    TabListItem tab1NavTab;
    @UiField
    TabListItem tab2NavTab;
    @UiField
    TabPane tab1Pane;
    @UiField
    TabPane tab2Pane;
    @UiField
    AlertDialog alertDialog;

    public AssetMgmtUi(HasConfiguration hasConfiguration, Configurations configurations) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        GwtConfigComponent assetConfiguration = hasConfiguration.getConfiguration();
        String driverPid = assetConfiguration.getParameterValue(AssetConstants.ASSET_DRIVER_PROP.value());
        GwtConfigComponent channelDescriptor = configurations.getChannelDescriptor(driverPid);
        if (channelDescriptor == null) {
            return;
        }
        AssetModelImpl model = new AssetModelImpl(new GwtConfigComponent(assetConfiguration), channelDescriptor, configurations.getBaseChannelDescriptor());
        this.assetDataUi = new AssetDataUi(model);
        this.assetConfigUi = new AssetConfigurationUi(model, (Widget)this.assetDataUi, configurations);
        ConfigurationUiButtons buttonBar = this.createAssetUiButtonBar(this.assetConfigUi, configurations);
        Panel panel = new Panel();
        panel.add((Widget)buttonBar);
        panel.add((Widget)this.assetConfigUi);
        this.tab1Pane.add((Widget)panel);
        this.tab2Pane.add((Widget)this.assetDataUi);
        this.tab2NavTab.addClickHandler(event -> {
            if (this.assetConfigUi.isDirty()) {
                this.alertDialog.show(MSGS.driversAssetsAssetConfigDirty(), AlertDialog.Severity.ALERT, null);
                event.stopPropagation();
                event.preventDefault();
                return;
            }
            this.assetDataUi.renderForm();
        });
    }

    public void refresh() {
        if (this.tab1NavTab.isActive()) {
            this.assetConfigUi.renderForm();
        } else {
            this.assetDataUi.renderForm();
        }
    }

    public void setDirty(boolean flag) {
        this.assetConfigUi.setDirty(flag);
        this.assetDataUi.setDirty(flag);
    }

    public boolean isDirty() {
        return this.assetConfigUi.isDirty() || this.assetDataUi.isDirty();
    }

    public ConfigurationUiButtons createAssetUiButtonBar(final AssetConfigurationUi assetUi, final Configurations configurations) {
        final GwtConfigComponent gwtConfig = assetUi.getConfiguration();
        ConfigurationUiButtons result = new ConfigurationUiButtons(assetUi);
        result.setListener(new ConfigurationUiButtons.Listener(){

            @Override
            public void onReset() {
                String driverPid = gwtConfig.getParameterValue(AssetConstants.ASSET_DRIVER_PROP.value());
                AssetModelImpl model = new AssetModelImpl(new GwtConfigComponent(configurations.getConfiguration(gwtConfig.getComponentId()).getConfiguration()), configurations.getChannelDescriptor(driverPid), configurations.getBaseChannelDescriptor());
                AssetMgmtUi.this.assetDataUi.setModel(model);
                assetUi.setModel(model);
            }

            @Override
            public void onApply() {
                GwtConfigComponent newConfig = assetUi.getConfiguration();
                DriversAndAssetsRPC.deleteFactoryConfiguration(newConfig.getComponentId(), result2 -> DriversAndAssetsRPC.createFactoryConfiguration(newConfig.getComponentId(), newConfig.getFactoryId(), newConfig, result1 -> {
                    configurations.setConfiguration(new GwtConfigComponent(newConfig));
                    assetUi.setDirty(false);
                }));
            }
        });
        return result;
    }

    static interface AssetMgmtUiUiBinder
    extends UiBinder<Widget, AssetMgmtUi> {
    }
}

