/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.kura.asset.Asset;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.driver.Driver;
import org.eclipse.kura.internal.wire.asset.WireAssetChannelDescriptor;
import org.eclipse.kura.web.server.KuraRemoteServiceServlet;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelServlet
extends HttpServlet {
    private static final long serialVersionUID = -1445700937173920652L;
    private static Logger logger = LoggerFactory.getLogger(ChannelServlet.class);
    private static final GwtConfigComponent WIRE_ASSET_CHANNEL_DESCRIPTOR = GwtServerUtil.toGwtConfigComponent(null, WireAssetChannelDescriptor.get().getDescriptor());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block12: {
            try {
                GwtXSRFToken token = new GwtXSRFToken(req.getParameter("xsrfToken"));
                KuraRemoteServiceServlet.checkXSRFToken(req, token);
                String assetPid = req.getParameter("assetPid");
                String driverPid = req.getParameter("driverPid");
                StringWriter out = new StringWriter();
                CSVPrinter printer = new CSVPrinter((Appendable)out, CSVFormat.RFC4180);
                if (!this.fillCsvFields(printer, assetPid, driverPid)) {
                    resp.getWriter().write("Error generating CSV output!");
                    break block12;
                }
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("text/csv");
                resp.setHeader("Content-Disposition", "attachment; filename=asset_" + assetPid + ".csv");
                resp.setHeader("Cache-Control", "no-transform,no-cache,no-store");
                resp.setHeader("Pragma", "no-cache");
                Throwable throwable = null;
                Object var9_11 = null;
                try (PrintWriter writer = resp.getWriter();){
                    writer.write(((Object)out).toString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                logger.error("Error while exporting CSV output!", (Throwable)ex);
            }
        }
    }

    private boolean fillCsvFields(CSVPrinter printer, String assetPid, String driverPid) {
        AtomicBoolean error = new AtomicBoolean(false);
        ArrayList orderedFields = new ArrayList();
        try {
            WIRE_ASSET_CHANNEL_DESCRIPTOR.getParameters().forEach(i -> {
                try {
                    printer.print((Object)i.getId().substring(1));
                }
                catch (IOException iOException) {
                    error.set(true);
                }
                orderedFields.add("+" + i.getId().substring(1));
            });
            this.withDriver(driverPid, driver -> {
                List descriptor = (List)driver.getChannelDescriptor().getDescriptor();
                for (AD ad : descriptor) {
                    try {
                        printer.print((Object)ad.getId());
                    }
                    catch (IOException iOException) {
                        error.set(true);
                    }
                    orderedFields.add(ad.getId());
                }
            });
            printer.println();
            this.withAsset(assetPid, asset -> asset.getAssetConfiguration().getAssetChannels().forEach((name, channel) -> {
                orderedFields.forEach(key -> {
                    try {
                        printer.print(channel.getConfiguration().get(key));
                    }
                    catch (IOException iOException) {
                        error.set(true);
                    }
                });
                try {
                    printer.println();
                }
                catch (IOException iOException) {
                    error.set(true);
                }
            }));
        }
        catch (Exception exception) {
            error.set(true);
        }
        return !error.get();
    }

    private void withAsset(String kuraServicePid, ServiceLocator.ServiceConsumer<Asset> consumer) throws Exception {
        String filter;
        BundleContext ctx = FrameworkUtil.getBundle(ServiceLocator.class).getBundleContext();
        Collection refs = ctx.getServiceReferences(Asset.class, filter = String.format("(%s=%s)", "kura.service.pid", kuraServicePid));
        if (refs == null || refs.isEmpty()) {
            return;
        }
        ServiceReference assetRef = (ServiceReference)refs.iterator().next();
        try {
            consumer.consume((Asset)ctx.getService(assetRef));
        }
        finally {
            ctx.ungetService(assetRef);
        }
    }

    private void withDriver(String kuraServicePid, ServiceLocator.ServiceConsumer<Driver> consumer) throws Exception {
        String filter;
        BundleContext ctx = FrameworkUtil.getBundle(ServiceLocator.class).getBundleContext();
        Collection refs = ctx.getServiceReferences(Driver.class, filter = String.format("(%s=%s)", "kura.service.pid", kuraServicePid));
        if (refs == null || refs.isEmpty()) {
            return;
        }
        ServiceReference driverRef = (ServiceReference)refs.iterator().next();
        try {
            consumer.consume((Driver)ctx.getService(driverRef));
        }
        finally {
            ctx.ungetService(driverRef);
        }
    }
}

