/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.asset.cloudlet;

import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.asset.Asset;
import org.eclipse.kura.asset.AssetService;
import org.eclipse.kura.util.collection.CollectionUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AssetTrackerCustomizer
implements ServiceTrackerCustomizer<Asset, Asset> {
    private static final Logger logger = LoggerFactory.getLogger(AssetTrackerCustomizer.class);
    private final Map<String, Asset> assets;
    private final AssetService assetService;
    private final BundleContext context;

    AssetTrackerCustomizer(BundleContext context, AssetService assetService) {
        Objects.requireNonNull(context, "Bundle context cannot be null");
        Objects.requireNonNull(context, "Asset service instance cannot be null");
        this.assets = CollectionUtil.newConcurrentHashMap();
        this.context = context;
        this.assetService = assetService;
    }

    public Asset addingService(ServiceReference<Asset> reference) {
        Asset service = (Asset)this.context.getService(reference);
        logger.info("Asset has been found by Asset Cloudlet Tracker... ==> adding service");
        if (service != null) {
            return this.addService(service);
        }
        return null;
    }

    private Asset addService(Asset service) {
        Objects.requireNonNull(service, "Asset service instance cannot be null");
        String assetPid = this.assetService.getAssetPid(service);
        this.assets.put(assetPid, service);
        return service;
    }

    Map<String, Asset> getRegisteredAssets() {
        return CollectionUtil.newConcurrentHashMap(this.assets);
    }

    public void modifiedService(ServiceReference<Asset> reference, Asset service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }

    public void removedService(ServiceReference<Asset> reference, Asset service) {
        String assetPid = String.valueOf(reference.getProperty("kura.service.pid"));
        this.context.ungetService(reference);
        if (assetPid != null && this.assets.containsKey(assetPid)) {
            this.assets.remove(assetPid);
        }
        logger.info("Asset has been removed by Asset Cloudlet Tracker... {}", (Object)service);
    }
}

