/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RPMUtils;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecCompletionProposal;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.parser.SpecfileSource;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileDefine;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileSection;

public class SpecfileCompletionProcessor
implements IContentAssistProcessor {
    private static final String SOURCE = "SOURCE";
    private static final String EMPTY_STRING = "";
    private static final String TEMPLATE_ICON = "icons/template_obj.gif";
    private static final String MACRO_ICON = "icons/macro_obj.gif";
    private static final String PATCH_ICON = "icons/macro_obj.gif";
    private static final String PACKAGE_ICON = "icons/rpm.gif";
    private static final String PREAMBLE_SECTION_TEMPLATE = "org.eclipse.linuxtools.rpm.ui.editor.preambleSection";
    private static final String PRE_SECTION_TEMPLATE = "org.eclipse.linuxtools.rpm.ui.editor.preSection";
    private static final String BUILD_SECTION_TEMPLATE = "org.eclipse.linuxtools.rpm.ui.editor.buildSection";
    private static final String INSTALL_SECTION_TEMPLATE = "org.eclipse.linuxtools.rpm.ui.editor.installSection";
    private static final String CHANGELOG_SECTION_TEMPLATE = "org.eclipse.linuxtools.rpm.ui.editor.changelogSection";

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<Object> result = new ArrayList<Object>();
        Specfile specfile = new SpecfileParser().parse(viewer.getDocument());
        String prefix = this.completionWord(viewer.getDocument(), offset);
        Region region = new Region(offset - prefix.length(), prefix.length());
        List<ICompletionProposal> rpmMacroProposals = this.computeRpmMacroProposals((IRegion)region, specfile, prefix);
        List<ICompletionProposal> sourcesProposals = this.computeSourcesProposals((IRegion)region, specfile, prefix);
        result.addAll(sourcesProposals);
        String currentContentType = viewer.getDocument().getDocumentPartitioner().getContentType(region.getOffset());
        if (currentContentType.equals("__spec_prep")) {
            List<ICompletionProposal> patchesProposals = this.computePatchesProposals((IRegion)region, specfile, prefix);
            result.addAll(patchesProposals);
        }
        if (currentContentType.equals("__spec_packages")) {
            List<ICompletionProposal> rpmPackageProposals = this.computeRpmPackageProposals((IRegion)region, prefix);
            result.addAll(rpmPackageProposals);
            result.addAll(rpmMacroProposals);
        } else {
            List<? extends ICompletionProposal> templateProposals = this.computeTemplateProposals(viewer, (IRegion)region, specfile, prefix);
            result.addAll(templateProposals);
            result.addAll(rpmMacroProposals);
        }
        if (currentContentType.equals("__spec_group")) {
            IDocument document = viewer.getDocument();
            try {
                int lineNumber = document.getLineOfOffset(region.getOffset());
                int lineOffset = document.getLineOffset(lineNumber);
                if (region.getOffset() - lineOffset > 5) {
                    result.clear();
                    String groupPrefix = this.getGroupPrefix(viewer, offset);
                    result.addAll(this.computeRpmGroupProposals((IRegion)region, groupPrefix));
                }
            }
            catch (BadLocationException e) {
                SpecfileLog.logError(e);
            }
        }
        return result.toArray(new ICompletionProposal[0]);
    }

    private List<? extends ICompletionProposal> computeTemplateProposals(ITextViewer viewer, IRegion region, Specfile specfile, String prefix) {
        Template[] templates;
        TemplateContext context = this.createContext(viewer, region, specfile);
        ArrayList<TemplateProposal> matches = new ArrayList<TemplateProposal>();
        if (context == null) {
            return matches;
        }
        String id = context.getContextType().getId();
        for (Template template : templates = Activator.getDefault().getTemplateStore().getTemplates(id)) {
            try {
                context.getContextType().validate(template.getPattern());
            }
            catch (TemplateException e) {
                continue;
            }
            int relevance = this.getRelevance(template, prefix);
            if (relevance <= 0) continue;
            matches.add(new TemplateProposal(template, context, region, Activator.getDefault().getImage(TEMPLATE_ICON), relevance));
        }
        Collections.sort(matches, (t1, t2) -> t2.getRelevance() - t1.getRelevance());
        return matches;
    }

    private List<ICompletionProposal> computeRpmMacroProposals(IRegion region, Specfile specfile, String prefix) {
        Map<String, String> rpmMacroProposalsMap = Activator.getDefault().getRpmMacroList().getProposals(prefix);
        rpmMacroProposalsMap.putAll(this.getDefines(specfile, prefix));
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (Map.Entry<String, String> entry : rpmMacroProposalsMap.entrySet()) {
            proposals.add(new SpecCompletionProposal("%{" + entry.getKey().substring(1) + "}", region.getOffset(), region.getLength(), entry.getKey().length() + 2, Activator.getDefault().getImage("icons/macro_obj.gif"), entry.getKey(), null, entry.getValue()));
        }
        return proposals;
    }

    private List<ICompletionProposal> computePatchesProposals(IRegion region, Specfile specfile, String prefix) {
        Map<String, String> patchesProposalsMap = this.getPatches(specfile, prefix);
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (Map.Entry<String, String> entry : patchesProposalsMap.entrySet()) {
            proposals.add(new SpecCompletionProposal(entry.getKey(), region.getOffset(), region.getLength(), entry.getKey().length(), Activator.getDefault().getImage("icons/macro_obj.gif"), entry.getKey(), null, entry.getValue()));
        }
        return proposals;
    }

    private List<ICompletionProposal> computeSourcesProposals(IRegion region, Specfile specfile, String prefix) {
        Map<String, String> sourcesProposalsMap = this.getSources(specfile, prefix);
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (Map.Entry<String, String> entry : sourcesProposalsMap.entrySet()) {
            proposals.add(new SpecCompletionProposal(entry.getKey(), region.getOffset(), region.getLength(), entry.getKey().length(), Activator.getDefault().getImage("icons/macro_obj.gif"), entry.getKey(), null, entry.getValue()));
        }
        return proposals;
    }

    private List<ICompletionProposal> computeRpmPackageProposals(IRegion region, String prefix) {
        List<String[]> rpmPkgProposalsList = Activator.getDefault().getRpmPackageList().getProposals(prefix);
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (rpmPkgProposalsList != null) {
            for (String[] item : rpmPkgProposalsList) {
                proposals.add(new SpecCompletionProposal(item[0], region.getOffset(), region.getLength(), item[0].length(), Activator.getDefault().getImage(PACKAGE_ICON), item[0], null, item[1]));
            }
        }
        Collections.sort(proposals, (a, b) -> a.getDisplayString().compareToIgnoreCase(b.getDisplayString()));
        return proposals;
    }

    private List<ICompletionProposal> computeRpmGroupProposals(IRegion region, String prefix) {
        List<String> rpmGroupProposalsList = Activator.getDefault().getRpmGroups();
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (String item : rpmGroupProposalsList) {
            if (!item.startsWith(prefix)) continue;
            proposals.add(new SpecCompletionProposal(item, region.getOffset(), region.getLength(), item.length(), Activator.getDefault().getImage(PACKAGE_ICON), item, null, item));
        }
        return proposals;
    }

    private TemplateContextType getContextType(Specfile specfile, int offset) {
        List<SpecfileSection> elements = specfile.getSections();
        if (elements.isEmpty() || offset < elements.get(0).getLineEndPosition()) {
            return Activator.getDefault().getContextTypeRegistry().getContextType(PREAMBLE_SECTION_TEMPLATE);
        }
        if (elements.size() == 1 || offset < elements.get(1).getLineEndPosition()) {
            return Activator.getDefault().getContextTypeRegistry().getContextType(PRE_SECTION_TEMPLATE);
        }
        if (elements.size() == 2 || offset < elements.get(2).getLineEndPosition()) {
            return Activator.getDefault().getContextTypeRegistry().getContextType(BUILD_SECTION_TEMPLATE);
        }
        if (elements.size() == 3 || offset < elements.get(3).getLineEndPosition()) {
            return Activator.getDefault().getContextTypeRegistry().getContextType(INSTALL_SECTION_TEMPLATE);
        }
        return Activator.getDefault().getContextTypeRegistry().getContextType(CHANGELOG_SECTION_TEMPLATE);
    }

    private TemplateContext createContext(ITextViewer viewer, IRegion region, Specfile specfile) {
        TemplateContextType contextType = this.getContextType(specfile, region.getOffset());
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new DocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
        }
        return null;
    }

    private int getRelevance(Template template, String prefix) {
        if (template.getName().startsWith(prefix)) {
            return 90;
        }
        return 0;
    }

    private String getGroupPrefix(ITextViewer viewer, int offset) {
        int i = offset;
        IDocument document = viewer.getDocument();
        if (i > document.getLength()) {
            return EMPTY_STRING;
        }
        try {
            char ch;
            while (i > 0 && (Character.isLetterOrDigit(ch = document.getChar(i - 1)) || ch == '/')) {
                --i;
            }
            return document.get(i, offset - i);
        }
        catch (BadLocationException e) {
            return EMPTY_STRING;
        }
    }

    private Map<String, String> getDefines(Specfile specfile, String prefix) {
        List<SpecfileDefine> defines = specfile.getDefines();
        HashMap<String, String> ret = new HashMap<String, String>();
        for (SpecfileDefine define : defines) {
            String defineName = "%" + define.getName();
            if (!defineName.startsWith(prefix.replaceFirst("\\{", EMPTY_STRING))) continue;
            ret.put(defineName, define.getStringValue());
        }
        return ret;
    }

    private Map<String, String> getPatches(Specfile specfile, String prefix) {
        List<SpecfileSource> patches = specfile.getPatches();
        HashMap<String, String> ret = new HashMap<String, String>();
        for (SpecfileSource patch : patches) {
            String patchName = "%patch" + patch.getNumber();
            if (!patchName.startsWith(prefix)) continue;
            ret.put(patchName.toLowerCase(), RPMUtils.getSourceOrPatchValue(specfile, "patch" + patch.getNumber()));
        }
        return ret;
    }

    private Map<String, String> getSources(Specfile specfile, String prefix) {
        List<SpecfileSource> sources = specfile.getSources();
        HashMap<String, String> ret = new HashMap<String, String>();
        for (SpecfileSource source : sources) {
            String sourceName = "%{SOURCE" + source.getNumber() + "}";
            if (!sourceName.startsWith(prefix)) continue;
            ret.put(sourceName, RPMUtils.getSourceOrPatchValue(specfile, SOURCE + source.getNumber()));
        }
        return ret;
    }

    private String completionWord(IDocument doc, int offset) {
        String word = null;
        if (offset > 0) {
            try {
                for (int n = offset - 1; n >= 0 && word == null; --n) {
                    char c = doc.getChar(n);
                    if (Character.isWhitespace(c)) {
                        word = doc.get(n + 1, offset - n - 1);
                        continue;
                    }
                    if (n != 0) continue;
                    word = doc.get(0, offset - n);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return word == null ? EMPTY_STRING : word;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

