/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.tests.mock;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CallHierarchyIncomingCall;
import org.eclipse.lsp4j.CallHierarchyIncomingCallsParams;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.lsp4j.CallHierarchyOutgoingCall;
import org.eclipse.lsp4j.CallHierarchyOutgoingCallsParams;
import org.eclipse.lsp4j.CallHierarchyPrepareParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.LinkedEditingRangeParams;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.lsp4j.TypeHierarchyPrepareParams;
import org.eclipse.lsp4j.TypeHierarchySubtypesParams;
import org.eclipse.lsp4j.TypeHierarchySupertypesParams;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.TextDocumentService;

public class MockTextDocumentService
implements TextDocumentService {
    private CompletionList mockCompletionList;
    private Hover mockHover;
    private List<? extends Location> mockDefinitionLocations;
    private List<? extends LocationLink> mockTypeDefinitions;
    private List<? extends TextEdit> mockFormattingTextEdits;
    private SignatureHelp mockSignatureHelp;
    private List<CodeLens> mockCodeLenses;
    private List<DocumentLink> mockDocumentLinks;
    private Map<Position, List<? extends DocumentHighlight>> mockDocumentHighlights;
    private LinkedEditingRanges mockLinkedEditingRanges;
    private CompletableFuture<DidOpenTextDocumentParams> didOpenCallback;
    private CompletableFuture<DidSaveTextDocumentParams> didSaveCallback;
    private CompletableFuture<DidCloseTextDocumentParams> didCloseCallback;
    private List<TextEdit> mockWillSaveWaitUntilTextEdits;
    private ConcurrentLinkedQueue<DidChangeTextDocumentParams> didChangeEvents = new ConcurrentLinkedQueue();
    private Function<?, ? extends CompletableFuture<?>> _futureFactory;
    private final List<LanguageClient> remoteProxies = new CopyOnWriteArrayList<LanguageClient>();
    private Location[] mockReferences = new Location[0];
    private List<Diagnostic> diagnostics;
    private List<Either<Command, CodeAction>> mockCodeActions;
    private List<ColorInformation> mockDocumentColors;
    private WorkspaceEdit mockRenameEdit;
    private Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior> mockPrepareRenameResult;
    private List<DocumentSymbol> documentSymbols;
    private SemanticTokens mockSemanticTokens;
    private List<FoldingRange> foldingRanges;
    public int codeActionRequests = 0;
    private static final Range DUMMY_RANGE = new Range(new Position(0, 0), new Position(0, 0));

    public <U> MockTextDocumentService(Function<U, CompletableFuture<U>> futureFactory) {
        this._futureFactory = futureFactory;
        CompletionItem item = new CompletionItem();
        item.setLabel("Mock completion item");
        this.mockCompletionList = new CompletionList(false, List.of(item));
        this.mockHover = new Hover(List.of(Either.forLeft((Object)"Mock hover")), null);
        this.mockPrepareRenameResult = Either3.forSecond((Object)new PrepareRenameResult(new Range(new Position(0, 0), new Position(0, 0)), "placeholder"));
        this.documentSymbols = Collections.emptyList();
        this.codeActionRequests = 0;
    }

    private <U> CompletableFuture<U> futureFactory(U value) {
        return this._futureFactory.apply(value);
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        return this.futureFactory(Either.forRight((Object)this.mockCompletionList));
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Hover> hover(HoverParams position) {
        return CompletableFuture.completedFuture(this.mockHover);
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams position) {
        return CompletableFuture.completedFuture(this.mockSignatureHelp);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams position) {
        return CompletableFuture.completedFuture(Either.forLeft(this.mockDefinitionLocations));
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return this.futureFactory(List.of(this.mockReferences));
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams params) {
        return CompletableFuture.completedFuture(this.mockDocumentHighlights != null ? this.mockDocumentHighlights.getOrDefault(params.getPosition(), Collections.emptyList()) : null);
    }

    public CompletableFuture<LinkedEditingRanges> linkedEditingRange(LinkedEditingRangeParams position) {
        return CompletableFuture.completedFuture(this.mockLinkedEditingRanges);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        String documentURI = params.getTextDocument().getUri();
        if (!documentURI.startsWith("file:///")) {
            throw new IllegalArgumentException("invalid uri: " + documentURI);
        }
        return CompletableFuture.completedFuture(this.documentSymbols.stream().map(symbol -> {
            Either res = Either.forRight((Object)symbol);
            return res;
        }).toList());
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        return CompletableFuture.completedFuture(this.mockDocumentLinks);
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        ++this.codeActionRequests;
        return this.futureFactory(this.mockCodeActions);
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        if (this.mockCodeLenses != null) {
            return CompletableFuture.completedFuture(this.mockCodeLenses);
        }
        File file = new File(URI.create(params.getTextDocument().getUri()));
        if (file.exists() && file.length() > 100L) {
            return CompletableFuture.completedFuture(List.of(new CodeLens(new Range(new Position(1, 0), new Position(1, 1)), new Command("Hi, I'm a CodeLens", null), null)));
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return CompletableFuture.completedFuture(this.mockFormattingTextEdits);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        Range range = params.getRange();
        List rangeEdits = this.mockFormattingTextEdits.stream().filter(edit -> this.inRange(range, edit.getRange())).collect(Collectors.toList());
        return CompletableFuture.completedFuture(rangeEdits);
    }

    private boolean inRange(Range containingRange, Range includedRange) {
        if (containingRange == null || includedRange == null) {
            throw new IllegalArgumentException();
        }
        if (containingRange.getStart().getLine() <= includedRange.getStart().getLine() && containingRange.getEnd().getLine() >= includedRange.getEnd().getLine()) {
            return !(containingRange.getStart().getLine() == includedRange.getStart().getLine() && containingRange.getStart().getCharacter() > includedRange.getStart().getCharacter() || containingRange.getEnd().getLine() == includedRange.getEnd().getLine() && containingRange.getEnd().getCharacter() < includedRange.getEnd().getCharacter());
        }
        return false;
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return CompletableFuture.completedFuture(this.mockRenameEdit);
    }

    public CompletableFuture<Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior>> prepareRename(PrepareRenameParams params) {
        return CompletableFuture.completedFuture(this.mockPrepareRenameResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didOpen(DidOpenTextDocumentParams params) {
        if (this.didOpenCallback != null) {
            this.didOpenCallback.complete(params);
            this.didOpenCallback = null;
        }
        if (this.diagnostics != null && !this.diagnostics.isEmpty()) {
            List<LanguageClient> list = this.remoteProxies;
            synchronized (list) {
                this.remoteProxies.get(0).publishDiagnostics(new PublishDiagnosticsParams(params.getTextDocument().getUri(), this.diagnostics));
                Collections.rotate(this.remoteProxies, 1);
            }
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        this.didChangeEvents.add(params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        if (this.didCloseCallback != null) {
            this.didCloseCallback.complete(params);
            this.didCloseCallback = null;
        }
    }

    public void didSave(DidSaveTextDocumentParams params) {
        if (this.didSaveCallback != null) {
            this.didSaveCallback.complete(params);
            this.didSaveCallback = null;
        }
    }

    public CompletableFuture<List<TextEdit>> willSaveWaitUntil(WillSaveTextDocumentParams params) {
        if (this.mockWillSaveWaitUntilTextEdits != null) {
            return CompletableFuture.completedFuture(this.mockWillSaveWaitUntilTextEdits);
        }
        return null;
    }

    public CompletableFuture<List<ColorInformation>> documentColor(DocumentColorParams params) {
        return CompletableFuture.completedFuture(this.mockDocumentColors);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> typeDefinition(TypeDefinitionParams position) {
        return CompletableFuture.completedFuture(Either.forRight(this.mockTypeDefinitions));
    }

    public CompletableFuture<CodeAction> resolveCodeAction(CodeAction unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public void setMockCompletionList(CompletionList completionList) {
        this.mockCompletionList = completionList;
    }

    public void setDidOpenCallback(CompletableFuture<DidOpenTextDocumentParams> didOpenExpectation) {
        this.didOpenCallback = didOpenExpectation;
    }

    public List<DidChangeTextDocumentParams> getDidChangeEvents() {
        return new ArrayList<DidChangeTextDocumentParams>(this.didChangeEvents);
    }

    public void setDidSaveCallback(CompletableFuture<DidSaveTextDocumentParams> didSaveExpectation) {
        this.didSaveCallback = didSaveExpectation;
    }

    public void setDidCloseCallback(CompletableFuture<DidCloseTextDocumentParams> didCloseExpectation) {
        this.didCloseCallback = didCloseExpectation;
    }

    public void setMockHover(Hover hover) {
        this.mockHover = hover;
    }

    public void setPrepareRenameResult(Either<Range, PrepareRenameResult> result) {
        this.mockPrepareRenameResult = result == null ? null : (Either3)result.map(Either3::forFirst, Either3::forSecond);
    }

    public void setMockCodeLenses(List<CodeLens> codeLenses) {
        this.mockCodeLenses = codeLenses;
    }

    public void setMockDefinitionLocations(List<? extends Location> definitionLocations) {
        this.mockDefinitionLocations = definitionLocations;
    }

    public void setMockReferences(Location ... locations) {
        this.mockReferences = locations;
    }

    public void setMockFormattingTextEdits(List<? extends TextEdit> formattingTextEdits) {
        this.mockFormattingTextEdits = formattingTextEdits;
    }

    public void setMockDocumentLinks(List<DocumentLink> documentLinks) {
        this.mockDocumentLinks = documentLinks;
    }

    public void reset() {
        this.mockCompletionList = new CompletionList();
        this.mockDefinitionLocations = Collections.emptyList();
        this.mockTypeDefinitions = Collections.emptyList();
        this.mockHover = null;
        this.mockCodeLenses = null;
        this.mockReferences = null;
        this.remoteProxies.clear();
        this.mockCodeActions = new ArrayList<Either<Command, CodeAction>>();
        this.mockRenameEdit = null;
        this.documentSymbols = Collections.emptyList();
        this.foldingRanges = new ArrayList<FoldingRange>();
        this.codeActionRequests = 0;
    }

    public void setDiagnostics(List<Diagnostic> diagnostics) {
        this.diagnostics = diagnostics;
    }

    public void addRemoteProxy(LanguageClient remoteProxy) {
        this.remoteProxies.add(remoteProxy);
    }

    public void setCodeActions(List<Either<Command, CodeAction>> codeActions) {
        this.mockCodeActions = codeActions;
    }

    public void setSignatureHelp(SignatureHelp signatureHelp) {
        this.mockSignatureHelp = signatureHelp;
    }

    public void setDocumentHighlights(Map<Position, List<? extends DocumentHighlight>> documentHighlights) {
        this.mockDocumentHighlights = documentHighlights;
    }

    public void setLinkedEditingRanges(LinkedEditingRanges linkedEditingRanges) {
        this.mockLinkedEditingRanges = linkedEditingRanges;
    }

    public void setDocumentColors(List<ColorInformation> colors) {
        this.mockDocumentColors = colors;
    }

    public void setRenameEdit(WorkspaceEdit edit) {
        this.mockRenameEdit = edit;
    }

    public void setMockTypeDefinitions(List<? extends LocationLink> mockTypeDefinitions) {
        this.mockTypeDefinitions = mockTypeDefinitions;
    }

    public void setDocumentSymbols(List<DocumentSymbol> symbols) {
        this.documentSymbols = symbols;
    }

    public void setWillSaveWaitUntilCallback(List<TextEdit> textEdits) {
        this.mockWillSaveWaitUntilTextEdits = textEdits;
    }

    public void setSemanticTokens(SemanticTokens semanticTokens) {
        this.mockSemanticTokens = semanticTokens;
    }

    public CompletableFuture<SemanticTokens> semanticTokensFull(SemanticTokensParams params) {
        return CompletableFuture.completedFuture(this.mockSemanticTokens);
    }

    public CompletableFuture<List<CallHierarchyItem>> prepareCallHierarchy(CallHierarchyPrepareParams params) {
        String uri = params.getTextDocument().getUri();
        CallHierarchyItem callee = new CallHierarchyItem();
        callee.setName("callee");
        callee.setKind(SymbolKind.Function);
        callee.setUri(uri);
        callee.setRange(DUMMY_RANGE);
        callee.setSelectionRange(DUMMY_RANGE);
        return CompletableFuture.completedFuture(List.of(callee));
    }

    public CompletableFuture<List<CallHierarchyIncomingCall>> callHierarchyIncomingCalls(CallHierarchyIncomingCallsParams params) {
        CallHierarchyItem caller = new CallHierarchyItem();
        caller.setName("caller");
        caller.setKind(SymbolKind.Function);
        caller.setUri(params.getItem().getUri());
        caller.setRange(DUMMY_RANGE);
        caller.setSelectionRange(DUMMY_RANGE);
        CallHierarchyIncomingCall incoming = new CallHierarchyIncomingCall();
        incoming.setFrom(caller);
        incoming.setFromRanges(List.of(DUMMY_RANGE));
        return CompletableFuture.completedFuture(List.of(incoming));
    }

    public CompletableFuture<List<CallHierarchyOutgoingCall>> callHierarchyOutgoingCalls(CallHierarchyOutgoingCallsParams params) {
        return CompletableFuture.completedFuture(List.of());
    }

    public CompletableFuture<List<TypeHierarchyItem>> prepareTypeHierarchy(TypeHierarchyPrepareParams params) {
        return CompletableFuture.completedFuture(List.of(new TypeHierarchyItem("a", SymbolKind.Class, params.getTextDocument().getUri(), DUMMY_RANGE, DUMMY_RANGE, null)));
    }

    public CompletableFuture<List<TypeHierarchyItem>> typeHierarchySubtypes(TypeHierarchySubtypesParams params) {
        return CompletableFuture.completedFuture(List.of(new TypeHierarchyItem(params.getItem().getName() + "a", SymbolKind.Class, params.getItem().getUri() + "/a", DUMMY_RANGE, DUMMY_RANGE, null), new TypeHierarchyItem(params.getItem().getName() + "b", SymbolKind.Class, params.getItem().getUri() + "/b", DUMMY_RANGE, DUMMY_RANGE, null)));
    }

    public CompletableFuture<List<TypeHierarchyItem>> typeHierarchySupertypes(TypeHierarchySupertypesParams params) {
        return CompletableFuture.completedFuture(List.of(new TypeHierarchyItem("X" + params.getItem().getName(), SymbolKind.Class, params.getItem().getUri() + "/X", DUMMY_RANGE, DUMMY_RANGE, null), new TypeHierarchyItem("Y" + params.getItem().getName(), SymbolKind.Class, params.getItem().getUri() + "/Y", DUMMY_RANGE, DUMMY_RANGE, null)));
    }

    public void setFoldingRanges(List<FoldingRange> foldingRanges) {
        this.foldingRanges = foldingRanges;
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return CompletableFuture.completedFuture(this.foldingRanges);
    }
}

