/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTTemplate.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.qvt.declarative.ecore.QVTBase.Pattern;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.CollectionTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.ObjectTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.PropertyTemplateItem;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.TemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.operations.AbstractQVTTemplateOperations;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.operations.QVTTemplateMessages;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.operations.TemplateExpOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTemplateItemOperations
extends AbstractQVTTemplateOperations {
    public static PropertyTemplateItemOperations INSTANCE = new PropertyTemplateItemOperations();

    public boolean checkCollectionElementTypeMatchesPropertyType(PropertyTemplateItem propertyTemplateItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCLExpression value = propertyTemplateItem.getValue();
        if (!(value instanceof CollectionTemplateExp)) {
            return true;
        }
        CollectionType valuesType = ((CollectionTemplateExp)value).getReferredCollectionType();
        if (valuesType == null) {
            return true;
        }
        EClassifier valueType = (EClassifier)valuesType.getElementType();
        if (valueType == null) {
            return true;
        }
        EStructuralFeature referredProperty = propertyTemplateItem.getReferredProperty();
        if (referredProperty == null) {
            return true;
        }
        EClassifier propertyType = this.getReferredPropertyType(propertyTemplateItem, false);
        if (propertyType == null) {
            return true;
        }
        if (this.assignableFrom(propertyType, valueType)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)valueType, context), this.getObjectLabel((EObject)propertyType, context), this.getObjectLabel((EObject)propertyTemplateItem.getReferredProperty(), context)};
        this.appendError(diagnostics, propertyTemplateItem, QVTTemplateMessages._UI_PropertyTemplateItem_ValueElementTypeDoesNotMatchReferredPropertyElementType, messageSubstitutions);
        return false;
    }

    public boolean checkEveryExpressionVariableIsBoundByPattern(PropertyTemplateItem propertyTemplateItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = TemplateExpOperations.INSTANCE.getPattern(propertyTemplateItem.getObjContainer());
        if (pattern == null) {
            return true;
        }
        EList bindsTo = pattern.getBindsTo();
        boolean allOk = true;
        OCLExpression value = propertyTemplateItem.getValue();
        if (value instanceof TemplateExp) {
            return true;
        }
        TreeIterator i = value.eAllContents();
        while (i.hasNext()) {
            VariableExp variableReference;
            Variable variable;
            EObject eObject = (EObject)i.next();
            if (!(eObject instanceof VariableExp) || (variable = (Variable)(variableReference = (VariableExp)eObject).getReferredVariable()) == null || this.isSpecialVariable(variable) || this.locallyDefined(variableReference) || bindsTo.contains(variable)) continue;
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)variable, context), this.getObjectLabel((EObject)pattern, context)};
            this.appendError(diagnostics, variableReference, QVTTemplateMessages._UI_PropertyTemplateItem_ExpressionVariableIsNotBoundByPattern, messageSubstitutions);
            allOk = false;
        }
        return allOk;
    }

    public boolean checkObjectTypeMatchesPropertyType(PropertyTemplateItem propertyTemplateItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCLExpression value = propertyTemplateItem.getValue();
        if (!(value instanceof ObjectTemplateExp)) {
            return true;
        }
        EClassifier valueType = (EClassifier)value.getType();
        if (valueType == null) {
            return true;
        }
        EStructuralFeature referredProperty = propertyTemplateItem.getReferredProperty();
        if (referredProperty == null) {
            return true;
        }
        EClassifier propertyType = this.getReferredPropertyType(propertyTemplateItem, false);
        if (propertyType == null) {
            return true;
        }
        if (this.assignableFrom(propertyType, valueType)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)valueType, context), this.getObjectLabel((EObject)propertyType, context), this.getObjectLabel((EObject)propertyTemplateItem.getReferredProperty(), context)};
        this.appendError(diagnostics, propertyTemplateItem, QVTTemplateMessages._UI_PropertyTemplateItem_ValueElementTypeDoesNotMatchReferredPropertyElementType, messageSubstitutions);
        return false;
    }

    public boolean checkReferredPropertyIsDefinedByReferredClass(PropertyTemplateItem propertyTemplateItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ObjectTemplateExp objectTemplateExp = propertyTemplateItem.getObjContainer();
        if (objectTemplateExp == null) {
            return true;
        }
        EClass referredClass = objectTemplateExp.getReferredClass();
        if (referredClass == null) {
            return true;
        }
        EStructuralFeature referredProperty = propertyTemplateItem.getReferredProperty();
        if (referredProperty == null) {
            return true;
        }
        if (propertyTemplateItem.isIsOpposite() ? this.definesOppositeProperty(referredClass, (EReference)referredProperty) : this.definesProperty(referredClass, referredProperty)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)referredProperty, context), this.getObjectLabel((EObject)referredClass, context)};
        this.appendError(diagnostics, objectTemplateExp, QVTTemplateMessages._UI_PropertyTemplateItem_ReferredPropertyIsNotDefinedByReferredClass, messageSubstitutions);
        return false;
    }

    public boolean checkValueElementTypeMatchesReferredPropertyElementType(PropertyTemplateItem propertyTemplateItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EClassifier propertyType = this.getReferredPropertyType(propertyTemplateItem, true);
        if (propertyType == null) {
            return true;
        }
        EClassifier propertyElementType = this.getTransitiveElementType(propertyType);
        if (propertyElementType == null) {
            return true;
        }
        OCLExpression value = propertyTemplateItem.getValue();
        if (value == null) {
            return true;
        }
        EClassifier valueElementType = this.getTransitiveElementType((EClassifier)value.getType());
        if (valueElementType == null) {
            return true;
        }
        if (this.assignableFrom(propertyElementType, valueElementType)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)valueElementType, context), this.getObjectLabel((EObject)propertyElementType, context), this.getObjectLabel((EObject)propertyTemplateItem.getReferredProperty(), context)};
        this.appendError(diagnostics, propertyTemplateItem, QVTTemplateMessages._UI_PropertyTemplateItem_ValueElementTypeDoesNotMatchReferredPropertyElementType, messageSubstitutions);
        return false;
    }

    public boolean checkSetMatchesSet(PropertyTemplateItem propertyTemplateItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CollectionKind propertyCollectionKind = this.getPropertyCollectionKind(propertyTemplateItem);
        if (propertyCollectionKind != CollectionKind.SET_LITERAL) {
            return true;
        }
        OCLExpression value = propertyTemplateItem.getValue();
        if (!(value instanceof CollectionTemplateExp)) {
            return true;
        }
        CollectionType valueCollectionType = ((CollectionTemplateExp)value).getReferredCollectionType();
        if (valueCollectionType instanceof SetType) {
            return true;
        }
        EClassifier referredPropertyType = this.getReferredPropertyType(propertyTemplateItem, true);
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)valueCollectionType, context), this.getObjectLabel((EObject)referredPropertyType, context), this.getObjectLabel((EObject)propertyTemplateItem.getReferredProperty(), context)};
        this.appendError(diagnostics, propertyTemplateItem, QVTTemplateMessages._UI_PropertyTemplateItem_SetDoesNotMatchSet, messageSubstitutions);
        return false;
    }

    public boolean checkNonBagMatchesNonBag(PropertyTemplateItem propertyTemplateItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CollectionKind propertyCollectionKind = this.getPropertyCollectionKind(propertyTemplateItem);
        if (propertyCollectionKind != CollectionKind.SEQUENCE_LITERAL && propertyCollectionKind != CollectionKind.ORDERED_SET_LITERAL) {
            return true;
        }
        OCLExpression value = propertyTemplateItem.getValue();
        if (!(value instanceof CollectionTemplateExp)) {
            return true;
        }
        CollectionType valueCollectionType = ((CollectionTemplateExp)value).getReferredCollectionType();
        if (valueCollectionType instanceof OrderedSetType || valueCollectionType instanceof SequenceType || valueCollectionType instanceof SetType) {
            return true;
        }
        EClassifier referredPropertyType = this.getReferredPropertyType(propertyTemplateItem, true);
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)valueCollectionType, context), this.getObjectLabel((EObject)referredPropertyType, context), this.getObjectLabel((EObject)propertyTemplateItem.getReferredProperty(), context)};
        this.appendError(diagnostics, propertyTemplateItem, QVTTemplateMessages._UI_PropertyTemplateItem_NonBagDDoesNotMatchNonBag, messageSubstitutions);
        return false;
    }

    protected CollectionKind getPropertyCollectionKind(PropertyTemplateItem propertyTemplateItem) {
        if (propertyTemplateItem.isIsOpposite()) {
            return null;
        }
        return PropertyTemplateItemOperations.getPropertyKind((EStructuralFeature)propertyTemplateItem.getReferredProperty());
    }

    protected EClassifier getReferredPropertyType(PropertyTemplateItem propertyTemplateItem, boolean synthesizeCollections) {
        EStructuralFeature referredProperty = propertyTemplateItem.getReferredProperty();
        if (referredProperty == null) {
            return null;
        }
        if (propertyTemplateItem.isIsOpposite()) {
            return referredProperty.getEContainingClass();
        }
        if (synthesizeCollections) {
            return PropertyTemplateItemOperations.getPropertyType((EStructuralFeature)referredProperty);
        }
        return referredProperty.getEType();
    }
}

