/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTBase.operations;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionLiteralPart;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.IterateExp;
import org.eclipse.ocl.ecore.LetExp;
import org.eclipse.ocl.ecore.LoopExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.TupleLiteralPart;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.qvt.declarative.ecore.operations.AbstractValidatorOperations;
import org.eclipse.qvt.declarative.ecore.operations.EValidatorWithOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractEssentialOCLOperations
extends AbstractValidatorOperations {
    private static final EcoreEnvironment ecoreEnvironment = (EcoreEnvironment)EcoreEnvironmentFactory.INSTANCE.createEnvironment();
    private static final OCLStandardLibrary<EClassifier> oclStandardLibrary = ecoreEnvironment.getOCLStandardLibrary();
    protected static final UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> uml = ecoreEnvironment.getUMLReflection();
    private static final EClassifier booleanType = (EClassifier)oclStandardLibrary.getBoolean();
    private static final EClassifier integerType = (EClassifier)oclStandardLibrary.getInteger();
    private static final EClassifier realType = (EClassifier)oclStandardLibrary.getReal();
    private static final EClassifier stringType = (EClassifier)oclStandardLibrary.getString();
    private static final EClassifier unlimitedNaturalType = (EClassifier)oclStandardLibrary.getUnlimitedNatural();
    private static final EClassifier voidType = (EClassifier)oclStandardLibrary.getOclVoid();

    public static EClassifier getBooleanType() {
        return booleanType;
    }

    public static EClassifier getIntegerType() {
        return integerType;
    }

    public static CollectionKind getPropertyKind(EStructuralFeature referredProperty) {
        if (referredProperty == null) {
            return null;
        }
        if (!referredProperty.isMany()) {
            return null;
        }
        if (referredProperty.isUnique()) {
            if (referredProperty.isOrdered()) {
                return CollectionKind.ORDERED_SET_LITERAL;
            }
            return CollectionKind.SET_LITERAL;
        }
        if (referredProperty.isOrdered()) {
            return CollectionKind.SEQUENCE_LITERAL;
        }
        return CollectionKind.BAG_LITERAL;
    }

    public static EClassifier getPropertyType(EStructuralFeature referredProperty) {
        EClassifier elementType = referredProperty.getEType();
        if (!referredProperty.isMany()) {
            return elementType;
        }
        Object collectionType = referredProperty.isUnique() ? (referredProperty.isOrdered() ? EcoreFactory.eINSTANCE.createOrderedSetType() : EcoreFactory.eINSTANCE.createSetType()) : (referredProperty.isOrdered() ? EcoreFactory.eINSTANCE.createSequenceType() : EcoreFactory.eINSTANCE.createBagType());
        collectionType.setElementType((Object)elementType);
        return collectionType;
    }

    public static EClassifier getRealType() {
        return realType;
    }

    public static EClassifier getStringType() {
        return stringType;
    }

    public static EClassifier getUnlimitedNaturalType() {
        return unlimitedNaturalType;
    }

    public static EClassifier getVoidType() {
        return voidType;
    }

    public static boolean locallyDefined(EObject element, Variable variable) {
        EObject parent;
        if (element instanceof LetExp) {
            if (((LetExp)element).getVariable() == variable) {
                return true;
            }
        } else if (element instanceof IterateExp) {
            if (((IterateExp)element).getResult() == variable) {
                return true;
            }
            if (((IterateExp)element).getIterator().contains((Object)variable)) {
                return true;
            }
        } else if (element instanceof LoopExp) {
            if (((LoopExp)element).getIterator().contains((Object)variable)) {
                return true;
            }
        } else if (!(element instanceof CollectionLiteralPart) && !(element instanceof TupleLiteralPart)) {
            if (element instanceof OCLExpression) {
                if (element.eContents().contains((Object)variable)) {
                    System.out.println("Missing child variable for " + element.getClass().getName());
                    return true;
                }
            } else {
                return false;
            }
        }
        if ((parent = element.eContainer()) == null) {
            return false;
        }
        return AbstractEssentialOCLOperations.locallyDefined(parent, variable);
    }

    public AbstractEssentialOCLOperations(EValidatorWithOperations validator) {
        super(validator);
    }

    protected boolean assignableFrom(EClassifier toType, EClassifier fromType) {
        EClassifier resolvedFromType;
        if (toType == null) {
            return false;
        }
        if (fromType == null) {
            return false;
        }
        EClassifier resolvedToType = (EClassifier)uml.getOCLType((Object)toType);
        if (resolvedToType == (resolvedFromType = (EClassifier)uml.getOCLType((Object)fromType))) {
            return true;
        }
        if (resolvedToType instanceof CollectionType) {
            CollectionType toCollectionType = (CollectionType)resolvedToType;
            EClassifier toElementType = (EClassifier)toCollectionType.getElementType();
            if (resolvedFromType instanceof CollectionType) {
                CollectionType fromCollectionType = (CollectionType)resolvedFromType;
                EClassifier fromElementType = (EClassifier)fromCollectionType.getElementType();
                if (fromElementType == AbstractEssentialOCLOperations.getVoidType()) {
                    return true;
                }
                return this.assignableFrom(toElementType, fromElementType);
            }
        } else {
            if (!(resolvedToType instanceof EClass)) {
                return false;
            }
            if (!(resolvedFromType instanceof EClass)) {
                return false;
            }
            return ((EClass)resolvedToType).isSuperTypeOf((EClass)resolvedFromType);
        }
        return false;
    }

    public Set<Variable> getAllReferencedVariables(EObject eObject) {
        HashSet<Variable> referencedVariables = new HashSet<Variable>();
        if (eObject instanceof VariableExp) {
            referencedVariables.add((Variable)((VariableExp)eObject).getReferredVariable());
        }
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            EObject element = (EObject)i.next();
            if (!(element instanceof VariableExp)) continue;
            referencedVariables.add((Variable)((VariableExp)element).getReferredVariable());
        }
        return referencedVariables;
    }

    public Collection<VariableExp> getAllVariableReferences(EObject eObject) {
        HashSet<VariableExp> variableExps = new HashSet<VariableExp>();
        if (eObject instanceof VariableExp) {
            variableExps.add((VariableExp)eObject);
        }
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            EObject element = (EObject)i.next();
            if (!(element instanceof VariableExp)) continue;
            variableExps.add((VariableExp)element);
        }
        return variableExps;
    }

    public Collection<Variable> getAllVariables(EObject eObject) {
        HashSet<Variable> variables = new HashSet<Variable>();
        if (eObject instanceof Variable) {
            variables.add((Variable)eObject);
        }
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            EObject element = (EObject)i.next();
            if (!(element instanceof Variable)) continue;
            variables.add((Variable)element);
        }
        return variables;
    }

    public EClassifier getTransitiveElementType(EClassifier type) {
        if (type instanceof CollectionType) {
            return this.getTransitiveElementType((EClassifier)((CollectionType)type).getElementType());
        }
        return type;
    }

    public EObject getNonExpressionParent(OCLExpression expression) {
        EObject parent = expression.eContainer();
        if (parent instanceof OCLExpression) {
            return this.getNonExpressionParent((OCLExpression)parent);
        }
        return parent;
    }

    public boolean isPredefinedType(EClassifier type) {
        if (type == AbstractEssentialOCLOperations.getBooleanType()) {
            return true;
        }
        if (type == AbstractEssentialOCLOperations.getIntegerType()) {
            return true;
        }
        if (type == AbstractEssentialOCLOperations.getRealType()) {
            return true;
        }
        if (type == AbstractEssentialOCLOperations.getStringType()) {
            return true;
        }
        return type == AbstractEssentialOCLOperations.getUnlimitedNaturalType();
    }

    public boolean locallyDefined(VariableExp variableReference) {
        Variable variable = (Variable)variableReference.getReferredVariable();
        return AbstractEssentialOCLOperations.locallyDefined((EObject)variableReference, variable);
    }
}

