/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.emf.workspace.ui.actions.RedoActionWrapper;
import org.eclipse.emf.workspace.ui.actions.UndoActionWrapper;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.qvt.declarative.editor.ui.CoreUtils;
import org.eclipse.qvt.declarative.editor.ui.IPageManager;
import org.eclipse.qvt.declarative.editor.ui.IPagedActionBarContributor;
import org.eclipse.qvt.declarative.editor.ui.actions.HideResourceAdaptersAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.StatusLineContributionItem;

public class PagedActionBarContributor
extends EcoreActionBarContributor
implements IPagedActionBarContributor {
    private static final StatusFieldDef[] STATUS_FIELD_DEFS = new StatusFieldDef[]{new StatusFieldDef("ElementState", null, true, 15), new StatusFieldDef("InputMode", "org.eclipse.ui.edit.text.toggleOverwrite", true, 14), new StatusFieldDef("InputPosition", "GotoLine", true, 14)};
    private IEditorPart activeEditorPart;
    private HideResourceAdaptersAction hideResourceAdaptersAction;
    private Map<StatusFieldDef, StatusLineContributionItem> fStatusFields;
    private Map<String, IAction> sharedActions = new HashMap<String, IAction>();

    public PagedActionBarContributor() {
        this.hideResourceAdaptersAction = new HideResourceAdaptersAction(this);
        this.fStatusFields = new HashMap<StatusFieldDef, StatusLineContributionItem>(3);
        int i = 0;
        while (i < STATUS_FIELD_DEFS.length) {
            StatusFieldDef fieldDef = STATUS_FIELD_DEFS[i];
            this.fStatusFields.put(fieldDef, new StatusLineContributionItem(fieldDef.category, fieldDef.visible, fieldDef.widthInChars));
            ++i;
        }
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        super.addGlobalActions(menuManager);
        String key = "ui-actions";
        if (this.hideResourceAdaptersAction != null) {
            menuManager.insertAfter(key, (IContributionItem)new ActionContributionItem((IAction)this.hideResourceAdaptersAction));
        }
    }

    public void contributeToMenu(IMenuManager manager) {
        super.contributeToMenu(manager);
        MenuManager menu = new MenuManager("Editor &Menu");
        manager.prependToGroup("additions", (IContributionItem)menu);
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
        int i = 0;
        while (i < STATUS_FIELD_DEFS.length) {
            statusLineManager.add((IContributionItem)this.fStatusFields.get(STATUS_FIELD_DEFS[i]));
            ++i;
        }
    }

    public void contributeToToolBar(IToolBarManager manager) {
        super.contributeToToolBar(manager);
        manager.add((IContributionItem)new Separator());
    }

    public HideResourceAdaptersAction getHideResourceAdaptersAction() {
        return this.hideResourceAdaptersAction;
    }

    public IAction getSharedAction(String actionId) {
        return this.sharedActions.get(actionId);
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.undoAction = new UndoActionWrapper();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new RedoActionWrapper();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        this.sharedActions.put(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.sharedActions.put(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        this.sharedActions.put(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.sharedActions.put(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.sharedActions.put(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.sharedActions.put(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
    }

    public void setActivePage(IEditorPart part) {
        if (this.activeEditorPart == part) {
            return;
        }
        this.activeEditorPart = part;
        IActionBars actionBars = this.getActionBars();
        IPageManager pageManager = CoreUtils.getAdapter((IAdaptable)part, IPageManager.class);
        if (actionBars != null && pageManager != null) {
            if (this.activeEditorPart instanceof ITextEditorExtension) {
                ITextEditorExtension extension = (ITextEditorExtension)this.activeEditorPart;
                int i = 0;
                while (i < STATUS_FIELD_DEFS.length) {
                    extension.setStatusField(null, STATUS_FIELD_DEFS[i].category);
                    ++i;
                }
            }
            this.setGlobalAction(actionBars, pageManager, ActionFactory.DELETE.getId());
            this.setGlobalAction(actionBars, pageManager, ActionFactory.UNDO.getId());
            this.setGlobalAction(actionBars, pageManager, ActionFactory.REDO.getId());
            this.setGlobalAction(actionBars, pageManager, ActionFactory.CUT.getId());
            this.setGlobalAction(actionBars, pageManager, ActionFactory.COPY.getId());
            this.setGlobalAction(actionBars, pageManager, ActionFactory.PASTE.getId());
            this.setGlobalAction(actionBars, pageManager, ActionFactory.SELECT_ALL.getId());
            this.setGlobalAction(actionBars, pageManager, ActionFactory.FIND.getId());
            this.setGlobalAction(actionBars, pageManager, ActionFactory.PROPERTIES.getId());
            this.setGlobalAction(actionBars, pageManager, ActionFactory.PRINT.getId());
            this.setGlobalAction(actionBars, pageManager, IDEActionFactory.BOOKMARK.getId());
            actionBars.updateActionBars();
            int i = 0;
            while (i < STATUS_FIELD_DEFS.length) {
                if (this.activeEditorPart instanceof ITextEditorExtension) {
                    StatusLineContributionItem statusField = this.fStatusFields.get(STATUS_FIELD_DEFS[i]);
                    if (STATUS_FIELD_DEFS[i].actionId != null) {
                        statusField.setActionHandler(pageManager.getAction(STATUS_FIELD_DEFS[i].actionId));
                    }
                    ITextEditorExtension extension = (ITextEditorExtension)this.activeEditorPart;
                    extension.setStatusField((IStatusField)statusField, STATUS_FIELD_DEFS[i].category);
                }
                ++i;
            }
        }
    }

    protected void setGlobalAction(IActionBars actionBars, IPageManager pageManager, String actionId) {
        IAction action = null;
        action = pageManager != null ? pageManager.getAction(actionId) : this.getSharedAction(actionId);
        actionBars.setGlobalActionHandler(actionId, action);
    }

    private static class StatusFieldDef {
        private String category;
        private String actionId;
        private boolean visible;
        private int widthInChars;

        private StatusFieldDef(String category, String actionId, boolean visible, int widthInChars) {
            Assert.isNotNull((Object)category);
            this.category = category;
            this.actionId = actionId;
            this.visible = visible;
            this.widthInChars = widthInChars;
        }
    }
}

