/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;

public class CyclicRegionsAnalysis {
    private final @NonNull Set<@NonNull RegionAnalysis> cyclicRegionAnalyses = new HashSet<RegionAnalysis>();
    private final @NonNull Set<@NonNull TraceClassAnalysis<@NonNull RegionAnalysis>> cyclicTraceClassAnalyses = new HashSet<TraceClassAnalysis<RegionAnalysis>>();

    public CyclicRegionsAnalysis(@NonNull Iterable<@NonNull RegionAnalysis> regionAnalyses) {
        this.analyze(regionAnalyses);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void analyze(@NonNull Iterable<@NonNull RegionAnalysis> regionAnalyses) {
        Map<@NonNull RegionAnalysis, @NonNull Set<@NonNull RegionAnalysis>> partitioner2predecessors = CompilerUtil.computeTransitivePredecessors(regionAnalyses);
        Map<@NonNull RegionAnalysis, @NonNull Set<@NonNull RegionAnalysis>> partitioner2successors = CompilerUtil.computeTransitiveSuccessors(partitioner2predecessors);
        for (RegionAnalysis regionAnalysis : regionAnalyses) {
            HashSet<@NonNull E> intersection = new HashSet(partitioner2predecessors.get(regionAnalysis));
            intersection.retainAll((Collection)partitioner2successors.get(regionAnalysis));
            this.cyclicRegionAnalyses.addAll(intersection);
        }
        if (this.cyclicRegionAnalyses.isEmpty()) {
            return;
        }
        HashSet<@NonNull @NonNull E> consumedTraceClassAnalyses = new HashSet();
        HashSet<@NonNull @NonNull E> superProducedTraceClassAnalyses = new HashSet();
        for (RegionAnalysis cyclicRegionAnalysis : this.cyclicRegionAnalyses) {
            Iterable superProducedTraceClassAnalyses2;
            Iterable<@NonNull TraceClassAnalysis<@NonNull RA>> consumedTraceClassAnalyses2 = cyclicRegionAnalysis.getConsumedTraceClassAnalyses();
            if (consumedTraceClassAnalyses2 != null) {
                Iterables.addAll(consumedTraceClassAnalyses, consumedTraceClassAnalyses2);
            }
            if ((superProducedTraceClassAnalyses2 = cyclicRegionAnalysis.getSuperProducedTraceClassAnalyses()) == null) continue;
            Iterables.addAll(superProducedTraceClassAnalyses, superProducedTraceClassAnalyses2);
        }
        this.cyclicTraceClassAnalyses.addAll(consumedTraceClassAnalyses);
        this.cyclicTraceClassAnalyses.retainAll(superProducedTraceClassAnalyses);
    }

    public boolean isCyclic(@NonNull RegionAnalysis regionAnalysis) {
        return this.cyclicRegionAnalyses.contains(regionAnalysis);
    }

    public boolean isCyclic(@NonNull TraceClassAnalysis<@NonNull RegionAnalysis> traceClassAnalysis) {
        assert (this.cyclicTraceClassAnalyses != null);
        return this.cyclicTraceClassAnalyses.contains(traceClassAnalysis);
    }
}

