/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfUtil {
    public static final String PATH_SEPARATOR = "::";
    public static final Map<Object, Object> DEFAULT_SAVE_OPTIONS = new HashMap<Object, Object>();

    static {
        DEFAULT_SAVE_OPTIONS.put("ENCODING", "UTF-8");
    }

    private EmfUtil() {
    }

    public static ModelContent loadModel(URI uri) {
        return EmfUtil.loadModel(uri, EmfUtil.getDefaultLoadOptions(), null);
    }

    public static ModelContent loadModel(URI uri, ResourceSet rs) {
        return EmfUtil.loadModel(uri, EmfUtil.getDefaultLoadOptions(), rs);
    }

    private static ModelContent loadModel(URI uri, Map<Object, Object> options, ResourceSet rs) {
        if (uri == null) {
            return null;
        }
        ResourceSet resourceSet = rs != null ? rs : EmfUtil.createResourceSet(options);
        String fragment = uri.fragment();
        if (fragment != null && fragment.length() > 0) {
            EObject eObject = resourceSet.getEObject(uri, true);
            if (eObject == null) {
                return null;
            }
            return new ModelContent(Collections.singletonList(eObject));
        }
        Resource resource = resourceSet.getResource(uri.trimFragment(), true);
        if (resource == null) {
            return null;
        }
        return new ModelContent((List<EObject>)resource.getContents());
    }

    public static ModelContent safeLoadModel(URI uri, ResourceSet rs) {
        return EmfUtil.safeLoadModel(uri, EmfUtil.getDefaultLoadOptions(), rs);
    }

    private static ModelContent safeLoadModel(URI uri, Map<Object, Object> options, ResourceSet rs) {
        try {
            return EmfUtil.loadModel(uri, options, rs);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Resource loadResource(URI uri) {
        return EmfUtil.createResourceSet(EmfUtil.getDefaultLoadOptions()).getResource(uri, true);
    }

    private static ResourceSet createResourceSet(Map<Object, Object> options) {
        ResourceSetImpl resourceSet = new ResourceSetImpl(){

            protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
                Resource resource = super.delegatedGetResource(uri, loadOnDemand);
                if (resource == null && !loadOnDemand) {
                    resource = this.lookupMetamodelRegistry(uri);
                }
                return resource;
            }

            protected Resource demandCreateResource(URI uri) {
                Resource resource = super.demandCreateResource(uri);
                if (resource == null) {
                    resource = this.lookupMetamodelRegistry(uri);
                }
                return resource;
            }

            private Resource lookupMetamodelRegistry(URI uri) {
                Resource resource = null;
                URI trimmedURI = uri.trimFragment();
                try {
                    IMetamodelDesc descriptor = MetamodelRegistry.getInstance().getMetamodelDesc(trimmedURI.toString());
                    EPackage ePackage = descriptor.getModel();
                    resource = ePackage.eResource();
                    if (resource == null) {
                        resource = new ResourceImpl(trimmedURI);
                        resource.getContents().add((Object)ePackage);
                    }
                }
                catch (EmfException e) {
                    EmfUtilPlugin.log(e);
                }
                return resource;
            }
        };
        resourceSet.getLoadOptions().putAll(options);
        return resourceSet;
    }

    public static EObject resolveSource(EObject in, EObject inputType) {
        if (inputType == null || inputType.eResource() == null) {
            return in;
        }
        return EmfUtil.resolveSource(in, inputType.eResource().getResourceSet());
    }

    public static EObject resolveSource(EObject in, ResourceSet rs) {
        if (rs != null && EmfUtil.isDynamic(in)) {
            URI uri;
            ResourceSet inRS;
            ResourceSet resourceSet = inRS = in.eResource() != null ? in.eResource().getResourceSet() : null;
            if (rs != inRS && (uri = EcoreUtil.getURI((EObject)in)) != null && !"#//".equals(uri.toString())) {
                return rs.getEObject(uri, true);
            }
        }
        return in;
    }

    public static boolean isUriExistsAsEObject(URI uri, ResourceSet rs, boolean validateNonEmpty) {
        ModelContent loadModel = null;
        try {
            loadModel = EmfUtil.loadModel(uri, rs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loadModel == null) {
            return false;
        }
        return validateNonEmpty ? !loadModel.getContent().isEmpty() : true;
    }

    public static boolean isDynamic(EObject eObject) {
        return eObject instanceof EStructuralFeature.Internal.DynamicValueHolder;
    }

    public static void saveModel(EObject eObject, URI uri, Map<Object, Object> opts) throws EmfException {
        ResourceSet resourceSet = EmfUtil.getOutputResourceSet();
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)eObject);
        HashMap<Object, Object> options = new HashMap<Object, Object>(opts);
        options.put("ENCODING", "UTF-8");
        if (EmfUtil.isDynamic(eObject)) {
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
        }
        try {
            resource.save(options);
        }
        catch (Exception e) {
            throw new EmfException(NLS.bind((String)Messages.EmfUtil_1, (Object)uri), e);
        }
    }

    public static void saveModel(Resource modelExtent, Map<Object, Object> opts) throws EmfException {
        HashMap<Object, Object> options = new HashMap<Object, Object>(opts);
        options.put("ENCODING", "UTF-8");
        options.put("PROCESS_DANGLING_HREF", "DISCARD");
        for (EObject eObject : modelExtent.getContents()) {
            if (!EmfUtil.isDynamic(eObject)) continue;
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
            break;
        }
        try {
            modelExtent.save(options);
        }
        catch (Exception e) {
            throw new EmfException(NLS.bind((String)Messages.EmfUtil_1, (Object)modelExtent.getURI()), e);
        }
    }

    public static ResourceSet getOutputResourceSet() {
        return new ResourceSetImpl();
    }

    public static EPackage getRootPackage(EPackage pack) {
        EPackage parent = pack.getESuperPackage();
        if (parent == null) {
            return pack;
        }
        return EmfUtil.getRootPackage(parent);
    }

    public static String getFullName(EClassifier cls) {
        return EmfUtil.getFullName(cls, PATH_SEPARATOR);
    }

    private static String getFullName(EClassifier cls, String delim) {
        if (cls.getEPackage() == null) {
            return cls.getName();
        }
        return String.valueOf(EmfUtil.getFullName(cls.getEPackage(), delim)) + delim + cls.getName();
    }

    public static String getFullName(EPackage pack) {
        return EmfUtil.getFullName(pack, PATH_SEPARATOR);
    }

    private static String getFullName(EPackage pack, String delim) {
        if (pack.getESuperPackage() != null) {
            return String.valueOf(EmfUtil.getFullName(pack.getESuperPackage(), delim)) + delim + pack.getName();
        }
        return pack.getName();
    }

    public static String getFullNameRelativeToPackage(EPackage ePackage, EPackage baseQwningPackage) {
        if (ePackage.getESuperPackage() != null && ePackage.getESuperPackage() != baseQwningPackage) {
            StringBuilder buf = new StringBuilder();
            EPackage nextPackage = ePackage;
            int i = 0;
            while (nextPackage != null && nextPackage != baseQwningPackage) {
                if (i > 0) {
                    buf.insert(0, PATH_SEPARATOR);
                }
                buf.insert(0, nextPackage.getName());
                nextPackage = nextPackage.getESuperPackage();
                ++i;
            }
            return String.valueOf(EmfUtil.getFullNameRelativeToPackage(ePackage.getESuperPackage(), baseQwningPackage)) + PATH_SEPARATOR + ePackage.getName();
        }
        return ePackage.getName();
    }

    public static String getFullNameRelativeToPackage(EClassifier eClassifier, EPackage baseOwningPackage) {
        EPackage immediateOwner = eClassifier.getEPackage();
        if (baseOwningPackage != null && immediateOwner != null && baseOwningPackage != immediateOwner) {
            String parentName = EmfUtil.getFullNameRelativeToPackage(immediateOwner, baseOwningPackage);
            return String.valueOf(parentName) + PATH_SEPARATOR + eClassifier.getName();
        }
        return eClassifier.getName();
    }

    public static EClass getEClass(EPackage root, String[] fullName) throws EmfException {
        EClassifier classifier = EmfUtil.getEClassifier(root, fullName);
        if (!(classifier instanceof EClass)) {
            throw new EmfException(NLS.bind((String)Messages.EmfUtil_6, (Object)fullName[fullName.length - 1]));
        }
        return (EClass)classifier;
    }

    private static EClassifier getEClassifier(EPackage root, String[] fullName) throws EmfException {
        if (fullName.length < 2) {
            throw new EmfException(NLS.bind((String)Messages.EmfUtil_2, Arrays.asList(fullName)));
        }
        String rootPackName = fullName[0];
        if (!rootPackName.equals(root.getName())) {
            throw new EmfException(NLS.bind((String)Messages.EmfUtil_3, (Object)rootPackName, (Object)root.getName()));
        }
        int i = 1;
        while (i < fullName.length - 1) {
            EPackage pack2;
            block4: {
                for (EPackage pack2 : root.getESubpackages()) {
                    if (!fullName[i].equals(pack2.getName())) continue;
                    break block4;
                }
                throw new EmfException(NLS.bind((String)Messages.EmfUtil_5, (Object)fullName[i]));
            }
            root = pack2;
            ++i;
        }
        EClassifier classifier = root.getEClassifier(fullName[fullName.length - 1]);
        return classifier;
    }

    public static URI makeUri(String uriString) {
        if (uriString == null || uriString.length() == 0) {
            return null;
        }
        URI uri = null;
        try {
            uri = URI.createURI((String)uriString);
        }
        catch (Exception e) {
            return null;
        }
        return uri;
    }

    public static String getRootPackageUri(EClassifier cls) {
        String uri = cls == null ? null : EmfUtil.getRootPackage(cls.getEPackage()).getNsURI();
        return uri;
    }

    public static boolean isAssignableFrom(EClassifier type, EClassifier from) {
        if (type == from) {
            return true;
        }
        if (!(from instanceof EClass)) {
            return false;
        }
        return ((EClass)from).getEAllSuperTypes().contains((Object)type);
    }

    public static Map<Object, Object> getDefaultLoadOptions() {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        return options;
    }

    public static Resource createResource(URI uri, ResourceSet outResourceSet) {
        Resource resource = outResourceSet.createResource(uri);
        if (resource != null) {
            return resource;
        }
        Object possibleFactory = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(uri.fileExtension());
        Resource.Factory factory = null;
        if (possibleFactory instanceof Resource.Factory) {
            factory = (Resource.Factory)possibleFactory;
        }
        if (possibleFactory instanceof Resource.Factory.Descriptor) {
            factory = ((Resource.Factory.Descriptor)possibleFactory).createFactory();
        }
        if (factory == null) {
            factory = new XMIResourceFactoryImpl();
        }
        return factory.createResource(uri);
    }

    public static boolean isUriMapped(ResourceSet resourceSet, URI uri) {
        Map uriMap;
        URIConverter converter;
        if (uri != null && (converter = resourceSet.getURIConverter()) != null && (uriMap = converter.getURIMap()) != null) {
            return uriMap.containsKey(uri);
        }
        return false;
    }

    public static void cleanupResourceSet(ResourceSet rs) {
        URI uri = URI.createURI((String)"");
        ArrayList resCopy = new ArrayList(rs.getResources());
        for (Resource res : resCopy) {
            if (!res.isLoaded()) continue;
            TreeIterator it = res.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                ((InternalEObject)eObject).eSetProxyURI(uri);
            }
            res.unload();
        }
        rs.getResources().clear();
        rs.eAdapters().clear();
    }

    public static boolean isUriExists(URI uri, ResourceSet rs, boolean validateNonEmpty) {
        URIConverter uriConverter;
        URIConverter uRIConverter = uriConverter = rs != null ? rs.getURIConverter() : URIConverter.INSTANCE;
        if (uriConverter.exists(uri, Collections.emptyMap())) {
            return true;
        }
        return EmfUtil.isUriExistsAsEObject(uri, rs, validateNonEmpty);
    }
}

