/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import com.ibm.icu.lang.UCharacter;
import java.io.Reader;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTParsingOptions;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.cst.CSTFactory;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.AbstractQVTParser;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QVTOLexer;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QVTOParser;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;

public class QvtOperationalParser {
    private RunnableQVTParser myParser;

    public static QVTOLexer createLexer(Reader is, String name, QvtOperationalEnv env) throws ParserException {
        QVTOLexer lexer = new QVTOLexer((Environment)env, QvtOperationalParser.correctLineBreaks(new OCLInput(is)), name, 4);
        return lexer;
    }

    public UnitCS parse(Reader is, String name, QvtOperationalEnv env) {
        UnitCS result = null;
        int sourceLength = 0;
        try {
            QVTOLexer lexer = QvtOperationalParser.createLexer(is, name, env);
            this.myParser = new RunnableQVTParser(lexer);
            this.myParser.enableCSTTokens(Boolean.TRUE.equals(env.getValue(QVTParsingOptions.ENABLE_CSTMODEL_TOKENS)));
            lexer.lexer(this.myParser.getIPrsStream());
            result = (UnitCS)this.myParser.runParser(-1);
            sourceLength = lexer.getILexStream().getStreamLength();
        }
        catch (ParserException ex) {
            env.reportError(ex.getLocalizedMessage(), 0, 0);
        }
        if (result == null) {
            if (!env.hasErrors()) {
                env.reportError(NLS.bind(CompilerMessages.moduleTransformationExpected, new Object[]{name}), 0, 0);
            }
            result = CSTFactory.eINSTANCE.createUnitCS();
        }
        result.setStartOffset(0);
        result.setEndOffset(sourceLength);
        return result;
    }

    public AbstractQVTParser getParser() {
        return this.myParser;
    }

    private static char[] correctLineBreaks(OCLInput input) throws ParserException {
        char[] contents = input.getContentAsString().toCharArray();
        int i = 0;
        while (i < contents.length) {
            int nextPos;
            char c = contents[i];
            if (c == '\r' && ((nextPos = i + 1) == contents.length || contents[nextPos] != '\n')) {
                contents[i] = 10;
            }
            ++i;
        }
        return contents;
    }

    private class RunnableQVTParser
    extends QVTOParser {
        public RunnableQVTParser(QVTOLexer lexStream) {
            super(lexStream);
        }

        public EObject runParser(int max_error_count) throws ParserException {
            return this.parser(max_error_count);
        }

        public String computeInputString(int left, int right) {
            char[] chars = this.getIPrsStream().getInputChars();
            if (right < left) {
                right = left;
            }
            if (right >= chars.length) {
                right = chars.length - 1;
            }
            StringBuffer result = new StringBuffer(right - left + 1);
            if (chars.length > 0) {
                int i = left;
                while (i <= right) {
                    if (chars[i] == '\t') {
                        result.append(' ');
                    } else if (chars[i] == '\n' || chars[i] == '\r' || chars[i] == '\f') {
                        if (i > 0 && !UCharacter.isWhitespace((int)chars[i - 1])) {
                            result.append(' ');
                        }
                    } else {
                        result.append(chars[i]);
                    }
                    ++i;
                }
            }
            return result.toString();
        }
    }
}

