/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.WrappedException;

public class StatusUtil {
    private StatusUtil() {
    }

    public static IStatus makeErrorStatus(String message) {
        return StatusUtil.makeStatus(4, message, null);
    }

    public static IStatus makeErrorStatus(String message, Exception e) {
        if (e instanceof WrappedException) {
            message = e.getCause().getMessage();
        }
        return StatusUtil.makeStatus(4, message, e);
    }

    public static IStatus makeErrorStatus(String format, String message, Exception e) {
        if (e instanceof WrappedException) {
            message = e.getCause().getMessage();
        }
        return StatusUtil.makeStatus(4, MessageFormat.format(format, message), e);
    }

    public static IStatus makeWarningStatus(String message) {
        return StatusUtil.makeStatus(2, message, null);
    }

    public static IStatus makeWarningStatus(String message, Exception e) {
        if (e instanceof WrappedException) {
            message = e.getCause().getMessage();
        }
        return StatusUtil.makeStatus(2, message, e);
    }

    public static IStatus makeOkStatus() {
        return StatusUtil.makeStatus(0, "", null);
    }

    private static IStatus makeStatus(int severity, String message, Exception e) {
        if (message == null) {
            message = "";
        }
        return new Status(severity, "org.eclipse.m2m.qvt.oml.emf.util", 1, message, (Throwable)e);
    }

    public static boolean isError(IStatus status) {
        return status.getSeverity() >= 4;
    }

    public static String getExceptionMessages(Throwable ex) {
        StringBuffer message = new StringBuffer();
        HashSet<String> used = new HashSet<String>();
        Throwable t = ex;
        while (t != null) {
            String m;
            if (!(t instanceof InvocationTargetException) && (m = t.getMessage()) != null && m.length() > 0 && !used.contains(m)) {
                if (message.length() > 0) {
                    message.append("\n");
                }
                message.append(m);
                used.add(m);
            }
            t = t.getCause();
        }
        if (message.length() == 0) {
            message.append(ex.getClass().getName());
        }
        return message.toString();
    }
}

