/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class MaxLengthFilter
extends FilterPlanNode {
    private final long maxLength;

    public MaxLengthFilter(PlanNode parent, long maxLength, ConnectionsGroup connectionsGroup) {
        super(parent, connectionsGroup);
        this.maxLength = maxLength;
    }

    @Override
    boolean checkTuple(FilterPlanNode.Reference t) {
        Value literal = t.get().getValue();
        return (long)literal.stringValue().length() <= this.maxLength;
    }

    @Override
    public String toString() {
        return "MaxLengthFilter{maxLength=" + this.maxLength + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MaxLengthFilter that = (MaxLengthFilter)o;
        return this.maxLength == that.maxLength;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxLength);
    }
}

