/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.widgets.internal;

import java.util.Collection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectPickerCombo<EntryType, DataType> {
    private final Combo actualCombo;
    private DataType selection = null;

    public ObjectPickerCombo(Composite parent, int style) {
        this.actualCombo = new Combo(parent, style | 8);
        this.actualCombo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ObjectPickerCombo.this.updateSelection();
            }
        });
    }

    public void setData(Collection<EntryType> entries) {
        this.actualCombo.removeAll();
        for (EntryType entry : entries) {
            int index = this.actualCombo.getItemCount();
            this.actualCombo.add(this.extractLabel(entry), index);
            this.actualCombo.setData(String.valueOf(index), this.extractData(entry));
        }
    }

    protected abstract String extractLabel(EntryType var1);

    protected abstract DataType extractData(EntryType var1);

    public Combo getControl() {
        return this.actualCombo;
    }

    private DataType getEntryData(int index) {
        return (DataType)this.actualCombo.getData(String.valueOf(index));
    }

    public DataType getSelection() {
        return this.selection;
    }

    public void select(DataType object) {
        if (object != null) {
            this.actualCombo.select(this.getFirstIndex(object));
            this.updateSelection();
        }
    }

    private int getFirstIndex(DataType data) throws NullPointerException {
        int i = 0;
        while (i < this.actualCombo.getItemCount()) {
            if (data.equals(this.getEntryData(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final void updateSelection() {
        int selectionIndex = this.actualCombo.getSelectionIndex();
        this.selection = this.getEntryData(selectionIndex);
        this.onSelectionChanged();
    }

    protected abstract void onSelectionChanged();
}

