/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby.parser;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;

public class RubyGemParser {
    private IFile file;
    private String gemVariable;
    private Map<String, List<String>> mSetupDefinitions = new HashMap<String, List<String>>();
    private Map<String, ArrayList<String>> mSetupDependencies = new HashMap<String, ArrayList<String>>();
    private static final String SETUP_START = "^gem[:\\.]{1,2}specification[:\\.]{1,2}new(\\s+)?do(\\s+)?\\|(\\s+)?(\\w+)(\\s+)?\\|";
    private static final String STRING = "(?:\\\"([^\\\"]+)\\\"|'([^']+)'|(?:%q|%Q)(?:([^\\w])([^/3].+)[^\\w]))";
    private static final String LIST = "(?!%q|%Q)(?:%w|%W)?(?:([\\W])(.+)[\\W])";
    private static final String STRING_LIST = "(?:\\\"([^\\\"]+)\\\"|'([^']+)')(?:[, ])??";
    private static final String GENERIC_LIST = "(?:\\S+)(?:\\s+)??";
    private static final String REPLACE_ME = "(%REPLACE_ME)";
    private String simpleDefineRx = "(\\s+)?(?!#)(?:\\b(%REPLACE_ME)\\b\\.(\\w+))(\\s+)?=(?!=)(\\s+)?(.*)";
    private String genericDefineRx = "(\\s+)?(?!#)(?:\\b(%REPLACE_ME)\\b\\.(\\w+))(\\s+)?(.*)";
    private String simpleFunctionRx = "(\\s+)?(?!#)(?:\\b(%REPLACE_ME)\\b\\.(\\w+))(\\s+)?(?:\\((.*)\\))(.*)?";

    public RubyGemParser(IFile file) throws IOException, CoreException {
        if (file.getContents().available() <= 0) {
            return;
        }
        this.file = file;
        this.gemVariable = "";
        this.parse();
    }

    public void parse() {
        ArrayList<String> rawSetupDefinitions = new ArrayList<String>();
        String line = "";
        try {
            Throwable throwable = null;
            Object var8_6 = null;
            try (RandomAccessFile raf = new RandomAccessFile(this.file.getRawLocation().makeAbsolute().toFile(), "r");){
                long startPos = this.findStart(raf);
                long endPos = RubyGemParser.findEnd(raf, startPos);
                raf.seek(startPos);
                while ((line = raf.readLine()) != null && raf.getFilePointer() < endPos) {
                    rawSetupDefinitions.add(line);
                }
                List<String> lSetupDefinitions = this.prepareOptions(rawSetupDefinitions);
                for (String str : lSetupDefinitions) {
                    this.parseLine(str);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            StubbyLog.logError(e);
        }
    }

    public List<String> getValueList(String key) {
        ArrayList<String> rc;
        block4: {
            block3: {
                rc = new ArrayList<String>();
                if (!this.mSetupDependencies.containsKey(key)) break block3;
                if (this.mSetupDependencies.get(key).isEmpty()) break block4;
                for (String element : this.mSetupDependencies.get(key)) {
                    rc.add(element);
                }
                break block4;
            }
            if (this.mSetupDefinitions.containsKey(key) && !this.mSetupDefinitions.get(key).isEmpty()) {
                for (String element : this.mSetupDefinitions.get(key)) {
                    rc.add(element);
                }
            }
        }
        return rc;
    }

    private void parseLine(String str) {
        if (str.matches(this.simpleDefineRx)) {
            this.parseSimpleDefine(str);
        } else if (str.matches(this.simpleFunctionRx)) {
            this.parseSimpleFunction(str);
        } else if (str.matches(this.genericDefineRx)) {
            this.parseGenericOption(str);
        }
    }

    private static List<String> parseValue(String str) {
        ArrayList<String> rc = new ArrayList<String>();
        String temp = str.trim();
        Pattern pattern = null;
        Matcher variableMatcher = null;
        if (temp.matches(STRING)) {
            pattern = Pattern.compile(STRING, 2);
            variableMatcher = pattern.matcher(temp);
            if (temp.startsWith("\"") && variableMatcher.matches()) {
                rc.add(variableMatcher.group(1));
            } else if (temp.startsWith("'") && variableMatcher.matches()) {
                rc.add(variableMatcher.group(2));
            } else if ((temp.startsWith("%q") || temp.startsWith("%Q")) && variableMatcher.matches()) {
                rc.add(variableMatcher.group(4));
            }
        } else if (temp.matches(LIST) && (variableMatcher = (pattern = Pattern.compile(LIST, 2)).matcher(temp)).matches()) {
            rc.addAll(RubyGemParser.parseList(variableMatcher.group(2)));
        }
        return rc;
    }

    private static List<String> parseList(String str) {
        ArrayList<String> rc = new ArrayList<String>();
        String temp = str.trim();
        Pattern pattern = RubyGemParser.isPatternFoundList(str);
        if (pattern == null) {
            return rc;
        }
        Matcher variableMatcher = pattern.matcher(temp);
        if (variableMatcher != null) {
            while (variableMatcher.find()) {
                rc.add(variableMatcher.group());
            }
        }
        return rc;
    }

    private static Pattern isPatternFoundList(String str) {
        Pattern rc = Pattern.compile("");
        Pattern pattern = Pattern.compile(STRING_LIST, 2);
        Matcher variableMatcher = pattern.matcher(str);
        rc = variableMatcher.find() ? pattern : RubyGemParser.isGenericFoundList(str);
        return rc;
    }

    private static Pattern isGenericFoundList(String str) {
        Pattern rc = Pattern.compile("");
        Pattern pattern = Pattern.compile(GENERIC_LIST, 2);
        Matcher variableMatcher = pattern.matcher(str);
        if (variableMatcher.find()) {
            rc = pattern;
        }
        return rc;
    }

    private void parseSimpleDefine(String str) {
        String temp = str.trim();
        Pattern pattern = Pattern.compile(this.simpleDefineRx, 2);
        Matcher variableMatcher = pattern.matcher(temp);
        if (variableMatcher.find()) {
            String optionName = variableMatcher.group(2);
            List<String> value = RubyGemParser.parseValue(variableMatcher.group(5));
            if (!value.isEmpty()) {
                this.mSetupDefinitions.put(optionName, value);
            }
        }
    }

    private void parseSimpleFunction(String str) {
        String temp = str.trim();
        Pattern pattern = Pattern.compile(this.simpleFunctionRx, 2);
        Matcher variableMatcher = pattern.matcher(temp);
        if (variableMatcher.find()) {
            String functionName = variableMatcher.group(2);
            ArrayList<String> dependencies = new ArrayList<String>();
            dependencies.add(variableMatcher.group(4));
            if (!this.mSetupDependencies.containsKey(functionName)) {
                this.mSetupDependencies.put(functionName, dependencies);
            } else if (!this.mSetupDependencies.get(functionName).containsAll(dependencies)) {
                this.mSetupDependencies.get(functionName).addAll(dependencies);
            }
        }
    }

    private void parseGenericOption(String str) {
        String temp = str.trim();
        Pattern pattern = Pattern.compile(this.genericDefineRx, 2);
        Matcher variableMatcher = pattern.matcher(temp);
        if (variableMatcher.find()) {
            String functionName = variableMatcher.group(2);
            ArrayList<String> dependencies = new ArrayList<String>();
            dependencies.add(variableMatcher.group(4));
            if (!this.mSetupDependencies.containsKey(functionName)) {
                this.mSetupDependencies.put(functionName, dependencies);
            } else if (!this.mSetupDependencies.get(functionName).containsAll(dependencies)) {
                this.mSetupDependencies.get(functionName).addAll(dependencies);
            }
        }
    }

    private List<String> prepareOptions(List<String> list) {
        ArrayList<String> rc = new ArrayList<String>();
        String temp = "";
        for (String str : list) {
            temp = str.trim();
            if (this.isLineValidOption(temp)) {
                rc.add(str);
                continue;
            }
            if (temp.startsWith("#") || rc.isEmpty()) continue;
            rc.set(rc.size() - 1, ((String)rc.get(rc.size() - 1)).concat(str));
        }
        return rc;
    }

    private boolean isLineValidOption(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile(this.genericDefineRx, 2);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.matches()) {
            rc = true;
        }
        return rc;
    }

    private long findStart(RandomAccessFile raf) throws IOException {
        long rc = -1L;
        Pattern pattern = Pattern.compile(SETUP_START, 2);
        Matcher variableMatcher = null;
        String line = "";
        raf.seek(0L);
        while ((line = raf.readLine()) != null && rc == -1L) {
            variableMatcher = pattern.matcher(line.trim());
            if (!variableMatcher.matches()) continue;
            this.setGemVariable(variableMatcher.group(4));
            rc = raf.getFilePointer();
        }
        return rc;
    }

    private static long findEnd(RandomAccessFile raf, long startPos) throws IOException {
        long rc = -1L;
        Pattern pattern = Pattern.compile("^end", 2);
        Matcher variableMatcher = null;
        String line = "";
        raf.seek(startPos);
        while ((line = raf.readLine()) != null && rc == -1L) {
            variableMatcher = pattern.matcher(line.trim());
            if (!variableMatcher.matches()) continue;
            rc = raf.getFilePointer();
        }
        return rc;
    }

    private void setGemVariable(String str) {
        if (this.gemVariable.isEmpty()) {
            this.gemVariable = str.trim();
            this.simpleDefineRx = this.simpleDefineRx.replace(REPLACE_ME, this.gemVariable);
            this.simpleFunctionRx = this.simpleFunctionRx.replace(REPLACE_ME, this.gemVariable);
            this.genericDefineRx = this.genericDefineRx.replace(REPLACE_ME, this.gemVariable);
        }
    }
}

