/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.jaxws;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.jaxws.WebServiceNewOperation;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws.WebServiceEditorInput;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.jaxws.WebServiceMessageDialog;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.jaxws.WebServiceNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class WebServiceNewWizard
extends AbstractWizard
implements INewWizard {
    private WebServiceNewWizardPage m_page1;
    private IWebServiceNewWizardFinishedAction m_finishAction;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.m_page1 = new WebServiceNewWizardPage();
        this.addPage((IWizardPage)this.m_page1);
        this.setWindowTitle(this.m_page1.getTitle());
        this.setHelpAvailable(true);
        this.setDefaultPageImageDescriptor(S2ESdkUiActivator.getImageDescriptor("newscoutprj_wiz.png"));
        this.setFinishAction(new P_ShowJaxwsEditorAction());
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        try {
            WebServiceNewWizardPage.WebServiceType webServiceType = this.m_page1.getWebServiceType();
            boolean createConsumer = WebServiceNewWizardPage.WebServiceType.CONSUMER_FROM_EXISTING_WSDL.equals((Object)webServiceType);
            boolean createFromEmptyWsdl = WebServiceNewWizardPage.WebServiceType.PROVIDER_FROM_EMPTY_WSDL.equals((Object)webServiceType);
            final WebServiceNewOperation op = new WebServiceNewOperation();
            op.setCreateConsumer(createConsumer);
            op.setCreateEmptyWsdl(createFromEmptyWsdl);
            if (createFromEmptyWsdl) {
                op.setWsdlName(this.m_page1.getWsdlName());
            } else if (createConsumer) {
                op.setWsdlUrl(new URL(this.m_page1.getConsumerWsdlUrl()));
            } else {
                op.setWsdlUrl(new URL(this.m_page1.getProviderWsdlUrl()));
            }
            op.setCreateNewModule(this.m_page1.isCreateNewProject());
            if (this.m_page1.isCreateNewProject()) {
                op.setServerModule(this.m_page1.getServerProject());
                op.setArtifactId(this.m_page1.getArtifactId());
            } else {
                op.setJaxWsProject(this.m_page1.getExistingJaxWsProject());
            }
            op.setPackage(this.m_page1.getTargetPackage());
            final Display d = this.getContainer().getShell().getDisplay();
            ResourceBlockingOperationJob job = new ResourceBlockingOperationJob((IOperation)op);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (!event.getResult().isOK()) {
                        return;
                    }
                    IWebServiceNewWizardFinishedAction finishAction = WebServiceNewWizard.this.getFinishAction();
                    if (finishAction == null) {
                        return;
                    }
                    finishAction.operationFinished(op, d);
                    d.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = JavaPlugin.getActiveWorkbenchShell();
                            if (shell == null) {
                                return;
                            }
                            WebServiceMessageDialog.open(shell, op);
                        }
                    });
                }
            });
            job.schedule();
            return true;
        }
        catch (MalformedURLException e) {
            SdkLog.error((String)"Invalid URL.", (Object[])new Object[]{e});
            return false;
        }
    }

    protected static void showJaxwsEditor(IFile jaxwsFile, IFile wsdl) {
        WebServiceEditorInput input = new WebServiceEditorInput(jaxwsFile);
        if (wsdl != null && wsdl.exists()) {
            input.setPageIdToActivate(wsdl.getName());
        }
        S2eUiUtils.openInEditor((IEditorInput)input, "org.eclipse.scout.sdk.s2e.ui.jaxwsEditor");
    }

    protected static IFile findJaxwsFile(IProject owner) {
        try {
            final IFile[] result = new IFile[1];
            owner.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    IFile resource;
                    if (result[0] == null && proxy.getType() == 1 && proxy.getName().toLowerCase().endsWith(".jaxws") && (resource = (IFile)proxy.requestResource()).exists()) {
                        result[0] = resource;
                        return false;
                    }
                    return true;
                }
            }, 1, 0);
            return result[0];
        }
        catch (CoreException e) {
            SdkLog.info((String)"Unable to search for thet jaxws file in project.", (Object[])new Object[]{e});
            return null;
        }
    }

    public WebServiceNewWizardPage getWebServiceNewWizardPage() {
        return this.m_page1;
    }

    public IWebServiceNewWizardFinishedAction getFinishAction() {
        return this.m_finishAction;
    }

    public void setFinishAction(IWebServiceNewWizardFinishedAction finishAction) {
        this.m_finishAction = finishAction;
    }

    public static interface IWebServiceNewWizardFinishedAction {
        public void operationFinished(WebServiceNewOperation var1, Display var2);
    }

    protected static class P_ShowJaxwsEditorAction
    implements IWebServiceNewWizardFinishedAction {
        protected P_ShowJaxwsEditorAction() {
        }

        @Override
        public void operationFinished(WebServiceNewOperation operation, Display d) {
            IJavaProject jaxWsProject = operation.getJaxWsProject();
            if (!S2eUtils.exists((IJavaElement)jaxWsProject)) {
                return;
            }
            final IFile jaxwsFile = WebServiceNewWizard.findJaxwsFile(jaxWsProject.getProject());
            if (jaxwsFile == null) {
                return;
            }
            final IFile wsdl = operation.getCreatedWsdlFile();
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    WebServiceNewWizard.showJaxwsEditor(jaxwsFile, wsdl);
                }
            });
        }
    }
}

