/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.functions;

import org.eclipse.jubula.client.core.functions.AbstractFunctionEvaluator;
import org.eclipse.jubula.client.core.functions.FunctionContext;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.propertytester.NodePropertyTester;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class NodeAttributeEvaluator
extends AbstractFunctionEvaluator {
    private static final String COMMENT_ATTRIBUTE = "comment";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String TASK_ID_ATTRIBUTE = "task.id";

    public String evaluate(String[] arguments) throws InvalidDataException {
        String attributeValue;
        block18: {
            block16: {
                this.validateParamCount(arguments, 1);
                String attributeName = arguments[0].toLowerCase();
                attributeValue = null;
                FunctionContext context = this.getContext();
                if (context == null) break block16;
                INodePO node = context.getNode();
                switch (attributeName) {
                    case "name": {
                        attributeValue = node.getName();
                        break block18;
                    }
                    case "comment": {
                        attributeValue = node.getComment();
                        break block18;
                    }
                    case "description": {
                        attributeValue = node.getDescription();
                        break block18;
                    }
                    case "task.id": {
                        attributeValue = NodePropertyTester.getTaskIdforNode((INodePO)node);
                        break block18;
                    }
                    default: {
                        throw new InvalidDataException("Unkown attribute: " + attributeName, MessageIDs.E_FUNCTION_EVAL_ERROR);
                    }
                }
            }
            throw new InvalidDataException("Function is being called without a node context!", MessageIDs.E_FUNCTION_EVAL_ERROR);
        }
        return attributeValue;
    }
}

