/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo.handler;

import java.io.OutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.rpm.createrepo.Activator;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoProject;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoUtils;
import org.eclipse.linuxtools.internal.rpm.createrepo.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.ide.ResourceUtil;

public class CreaterepoCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        final String executionType = event.getParameter("executionType");
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchPage wbPage = wb.getActiveWorkbenchWindow().getActivePage();
            IEditorInput editorInput = wbPage.getActiveEditor().getEditorInput();
            IResource resource = ResourceUtil.getResource((IEditorInput)editorInput);
            final CreaterepoProject project = new CreaterepoProject(resource.getProject());
            Job executeCreaterepo = new Job(Messages.Createrepo_jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(Messages.CreaterepoProject_executeCreaterepo, -1);
                        MessageConsoleStream os = CreaterepoUtils.findConsole(Messages.CreaterepoProject_consoleName).newMessageStream();
                        if (executionType.equals("refresh")) {
                            IStatus iStatus = project.update((OutputStream)os);
                            return iStatus;
                        }
                        IStatus iStatus = project.createrepo((OutputStream)os);
                        return iStatus;
                    }
                    catch (CoreException e) {
                        Activator.logError(Messages.Createrepo_errorExecuting, e);
                    }
                    finally {
                        monitor.done();
                    }
                    return null;
                }
            };
            executeCreaterepo.setUser(true);
            executeCreaterepo.schedule();
        }
        catch (CoreException e) {
            Activator.logError(Messages.CreaterepoProject_executeCreaterepo, e);
        }
        return null;
    }
}

