/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.mm.chess;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Types implements Enumerator
{
    NONE(0, "none", "none"),
    KING(1, "king", "king"),
    QUEEN(2, "queen", "queen"),
    ROOK(3, "rook", "rook"),
    KNIGHT(4, "knight", "knight"),
    BISHOP(5, "bishop", "bishop"),
    PAWN(6, "pawn", "pawn");

    public static final int NONE_VALUE = 0;
    public static final int KING_VALUE = 1;
    public static final int QUEEN_VALUE = 2;
    public static final int ROOK_VALUE = 3;
    public static final int KNIGHT_VALUE = 4;
    public static final int BISHOP_VALUE = 5;
    public static final int PAWN_VALUE = 6;
    private static final Types[] VALUES_ARRAY;
    public static final List<Types> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Types[]{NONE, KING, QUEEN, ROOK, KNIGHT, BISHOP, PAWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Types get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Types result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Types getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Types result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Types get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return KING;
            }
            case 2: {
                return QUEEN;
            }
            case 3: {
                return ROOK;
            }
            case 4: {
                return KNIGHT;
            }
            case 5: {
                return BISHOP;
            }
            case 6: {
                return PAWN;
            }
        }
        return null;
    }

    private Types(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

