/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.extensionpoints.profile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.uml.extensionpoints.Activator;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.standard.RegisteredElementExtensionPoint;

public class RegisteredProfile
extends RegisteredElementExtensionPoint
implements IRegisteredProfile {
    private static final String TAG_PROFILE = "profile";
    private static final String ATT_QUALIFIED_NAMES = "qualifiednames";

    public RegisteredProfile(IConfigurationElement configElt, int ordinal) {
        super(configElt, ordinal);
        this.qualifiednames = RegisteredProfile.getAttribute(configElt, ATT_QUALIFIED_NAMES, "", false);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getQualifiedNames() {
        return this.qualifiednames;
    }

    public static IRegisteredProfile getRegisteredProfile(String name) {
        return RegisteredProfile.getRegisteredProfile(name, null);
    }

    public static IRegisteredProfile getRegisteredProfile(String name, String path) {
        Assert.isNotNull((Object)name);
        IRegisteredProfile[] profiles = Registry.getRegisteredProfiles().toArray(new IRegisteredProfile[0]);
        int i = 0;
        while (i < profiles.length) {
            IRegisteredProfile profile = profiles[i];
            if (name.equals(profile.getName())) {
                if (path == null) {
                    return profile;
                }
                if (path.equals(profile.getPath())) {
                    return profile;
                }
            }
            ++i;
        }
        return null;
    }

    public static List<IRegisteredProfile> getRegisteredProfiles() {
        ArrayList<IRegisteredProfile> profiles = new ArrayList<IRegisteredProfile>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.uml.extensionpoints.UMLProfile");
        int j = 0;
        while (j < configElements.length) {
            IRegisteredProfile proxy = RegisteredProfile.parseProfileExtension(configElements[j], profiles.size());
            if (proxy != null) {
                profiles.add(proxy);
            }
            ++j;
        }
        return profiles;
    }

    private static IRegisteredProfile parseProfileExtension(IConfigurationElement configElt, int ordinal) {
        if (!TAG_PROFILE.equals(configElt.getName())) {
            return null;
        }
        try {
            return new RegisteredProfile(configElt, ordinal);
        }
        catch (Exception e) {
            String name = configElt.getAttribute("name");
            if (name == null) {
                name = "[missing name attribute]";
            }
            String msg = "Failed to load profile named " + name + " in " + configElt.getDeclaringExtension().getExtensionPointUniqueIdentifier();
            Activator.log(msg);
            return null;
        }
    }
}

