/**
 * Copyright (c) 2010-2012, Mark Czotter, Andras Okros, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.jvmmodel;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFPatternLanguageGeneratorConfig;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Model Inferrer for Pattern grouping. Infers a Group class for every PatternModel.
 * @noreference
 */
@SuppressWarnings("all")
public class PatternGroupClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Extension
  private JvmTypeReferenceBuilder builder;
  
  public JvmGenericType inferPatternGroupClass(final PatternModel model, final JvmTypeReferenceBuilder builder, final EMFPatternLanguageGeneratorConfig config, final boolean includePrivate) {
    JvmGenericType _xblockexpression = null;
    {
      this.builder = builder;
      final Procedure1<JvmGenericType> _function = (JvmGenericType it) -> {
        it.setPackageName(this.groupPackageName(model, includePrivate));
        it.setFinal(true);
        EList<JvmTypeReference> _superTypes = it.getSuperTypes();
        JvmTypeReference _typeRef = this.builder.typeRef(BaseGeneratedPatternGroup.class);
        this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
        this._eMFJvmTypesBuilder.setFileHeader(it, this._eMFPatternLanguageJvmModelInferrerUtil.getFileComment(model));
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toClass(model, this.groupClassName(model, includePrivate), _function);
    }
    return _xblockexpression;
  }
  
  public void initializePatternGroup(final JvmGenericType groupClass, final PatternModel model, final JvmTypeReferenceBuilder builder, final EMFPatternLanguageGeneratorConfig config, final boolean includePrivate) {
    this.builder = builder;
    this._eMFJvmTypesBuilder.setDocumentation(groupClass, this._javadocInferrer.javadocGroupClass(model, includePrivate).toString());
    EList<JvmMember> _members = groupClass.getMembers();
    JvmOperation _inferInstanceMethod = this.inferInstanceMethod(model, groupClass);
    this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _inferInstanceMethod);
    EList<JvmMember> _members_1 = groupClass.getMembers();
    JvmField _inferInstanceField = this.inferInstanceField(model, groupClass);
    this._eMFJvmTypesBuilder.<JvmField>operator_add(_members_1, _inferInstanceField);
    EList<JvmMember> _members_2 = groupClass.getMembers();
    JvmConstructor _inferConstructor = this.inferConstructor(model, groupClass, includePrivate);
    this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members_2, _inferConstructor);
    if (((!includePrivate) && (config.getMatcherGenerationStrategy() != EMFPatternLanguageGeneratorConfig.MatcherGenerationStrategy.USE_GENERIC))) {
      final Function1<Pattern, Boolean> _function = (Pattern it) -> {
        return Boolean.valueOf((this._eMFPatternLanguageJvmModelInferrerUtil.isPublic(it) && (!StringExtensions.isNullOrEmpty(it.getName()))));
      };
      Iterable<Pattern> _filter = IterableExtensions.<Pattern>filter(model.getPatterns(), _function);
      for (final Pattern pattern : _filter) {
        {
          EList<JvmMember> _members_3 = groupClass.getMembers();
          JvmOperation _inferSpecificationGetter = this.inferSpecificationGetter(pattern, groupClass, this._eMFPatternLanguageJvmModelInferrerUtil.findInferredSpecification(pattern));
          this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _inferSpecificationGetter);
          EList<JvmMember> _members_4 = groupClass.getMembers();
          JvmOperation _inferMatcherGetter = this.inferMatcherGetter(pattern, groupClass, this._eMFPatternLanguageJvmModelInferrerUtil.findInferredClass(pattern, BaseMatcher.class));
          this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _inferMatcherGetter);
        }
      }
    }
  }
  
  private String groupClassName(final PatternModel model, final boolean includePrivate) {
    final String fileName = StringExtensions.toFirstUpper(this._eMFPatternLanguageJvmModelInferrerUtil.modelFileName(model));
    String _xifexpression = null;
    if (includePrivate) {
      _xifexpression = (fileName + "All");
    } else {
      _xifexpression = fileName;
    }
    return _xifexpression;
  }
  
  private String groupPackageName(final PatternModel model, final boolean includePrivate) {
    final String packageName = model.getPackageName();
    String _xifexpression = null;
    if (includePrivate) {
      _xifexpression = (packageName + ".internal");
    } else {
      _xifexpression = packageName;
    }
    return _xifexpression;
  }
  
  public JvmField inferInstanceField(final PatternModel model, final JvmType groupClass) {
    final Procedure1<JvmField> _function = (JvmField it) -> {
      it.setVisibility(JvmVisibility.PRIVATE);
      it.setStatic(true);
    };
    return this._eMFJvmTypesBuilder.toField(model, "INSTANCE", this.builder.typeRef(groupClass), _function);
  }
  
  public JvmOperation inferInstanceMethod(final PatternModel model, final JvmType groupClass) {
    final Procedure1<JvmOperation> _function = (JvmOperation it) -> {
      this._eMFJvmTypesBuilder.setDocumentation(it, this._javadocInferrer.javadocGroupClassInstanceMethod(model).toString());
      it.setVisibility(JvmVisibility.PUBLIC);
      it.setStatic(true);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("if (INSTANCE == null) {");
          _builder.newLine();
          _builder.append("    ");
          _builder.append("INSTANCE = new ");
          _builder.append(groupClass, "    ");
          _builder.append("();");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
          _builder.append("return INSTANCE;");
          _builder.newLine();
        }
      };
      this._eMFJvmTypesBuilder.setBody(it, _client);
    };
    return this._eMFJvmTypesBuilder.toMethod(model, "instance", this.builder.typeRef(groupClass), _function);
  }
  
  public JvmConstructor inferConstructor(final PatternModel model, final JvmType groupClass, final boolean includePrivate) {
    final Procedure1<JvmConstructor> _function = (JvmConstructor it) -> {
      it.setVisibility(JvmVisibility.PRIVATE);
      it.setSimpleName(this.groupClassName(model, includePrivate));
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          {
            final Function1<Pattern, Boolean> _function = (Pattern it_1) -> {
              return Boolean.valueOf((includePrivate || PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.isPublic(it_1)));
            };
            final Function1<Pattern, JvmTypeReference> _function_1 = (Pattern it_1) -> {
              JvmType _findInferredSpecification = PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.findInferredSpecification(it_1);
              JvmTypeReference _typeRef = null;
              if (_findInferredSpecification!=null) {
                _typeRef=PatternGroupClassInferrer.this.builder.typeRef(_findInferredSpecification);
              }
              return _typeRef;
            };
            Iterable<JvmTypeReference> _filterNull = IterableExtensions.<JvmTypeReference>filterNull(IterableExtensions.<Pattern, JvmTypeReference>map(IterableExtensions.<Pattern>filterNull(IterableExtensions.<Pattern>filter(model.getPatterns(), _function)), _function_1));
            for(final JvmTypeReference matcherRef : _filterNull) {
              _builder.append("querySpecifications.add(");
              _builder.append(matcherRef);
              _builder.append(".instance());");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      };
      this._eMFJvmTypesBuilder.setBody(it, _client);
    };
    return this._eMFJvmTypesBuilder.toConstructor(model, _function);
  }
  
  public JvmOperation inferSpecificationGetter(final Pattern model, final JvmType groupClass, final JvmType specificationClass) {
    JvmOperation _xblockexpression = null;
    {
      JvmTypeReference _xifexpression = null;
      if ((specificationClass == null)) {
        _xifexpression = this.builder.typeRef(Object.class);
      } else {
        _xifexpression = this.builder.typeRef(specificationClass);
      }
      final JvmTypeReference classRef = _xifexpression;
      String _firstUpper = StringExtensions.toFirstUpper(model.getName());
      String _plus = ("get" + _firstUpper);
      final Procedure1<JvmOperation> _function = (JvmOperation it) -> {
        it.setVisibility(JvmVisibility.PUBLIC);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return ");
            _builder.append(classRef);
            _builder.append(".instance();");
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toMethod(model, _plus, classRef, _function);
    }
    return _xblockexpression;
  }
  
  public JvmOperation inferMatcherGetter(final Pattern model, final JvmType groupClass, final JvmType matcherClass) {
    JvmOperation _xblockexpression = null;
    {
      JvmTypeReference _xifexpression = null;
      if ((matcherClass == null)) {
        _xifexpression = this.builder.typeRef(Object.class);
      } else {
        _xifexpression = this.builder.typeRef(matcherClass);
      }
      final JvmTypeReference classRef = _xifexpression;
      String _firstUpper = StringExtensions.toFirstUpper(model.getName());
      String _plus = ("get" + _firstUpper);
      final Procedure1<JvmOperation> _function = (JvmOperation it) -> {
        it.setVisibility(JvmVisibility.PUBLIC);
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmFormalParameter _parameter = this._eMFJvmTypesBuilder.toParameter(model, "engine", this.builder.typeRef(ViatraQueryEngine.class));
        this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return ");
            _builder.append(classRef);
            _builder.append(".on(engine);");
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toMethod(model, _plus, classRef, _function);
    }
    return _xblockexpression;
  }
}
