/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.internal.plugin.JaxWsDomRuntimeMessages;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.ICompilationUnitFinder;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.ICompilationUnitHandler;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IProjectSelector;

public class WorkspaceCUFinder
implements ICompilationUnitFinder {
    private final IJavaModel javaModel;
    private final IProjectSelector[] selectors;

    public WorkspaceCUFinder(IJavaModel javaModel, IProjectSelector[] selectors) {
        if (javaModel == null) {
            throw new NullPointerException("javaModel");
        }
        this.javaModel = javaModel;
        if (selectors == null) {
            throw new NullPointerException("selector");
        }
        this.selectors = selectors;
    }

    @Override
    public void find(IProgressMonitor monitor, ICompilationUnitHandler cuHandler) throws CoreException, WsDOMLoadCanceledException {
        cuHandler.started();
        if (monitor != null) {
            monitor.beginTask(JaxWsDomRuntimeMessages.JAXWS_DOM_LOADING, this.assumeWork());
        }
        try {
            IJavaProject[] iJavaProjectArray = this.javaModel.getJavaProjects();
            int n = iJavaProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject prj = iJavaProjectArray[n2];
                if (monitor != null && monitor.isCanceled()) {
                    throw new WsDOMLoadCanceledException("JAX-WS DOM loading canceled", JaxWsDomRuntimeMessages.WorkspaceCUFinder_LOADING_CANCELED);
                }
                if (this.approve(prj)) {
                    cuHandler.handle(prj);
                    this.parseProject(prj, monitor, cuHandler);
                }
                ++n2;
            }
            cuHandler.finished();
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected int assumeWork() throws CoreException, WsDOMLoadCanceledException {
        CountingCUHandler countingHandler = new CountingCUHandler();
        IJavaProject[] iJavaProjectArray = this.javaModel.getJavaProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject prj = iJavaProjectArray[n2];
            if (this.approve(prj)) {
                this.parseProject(prj, (IProgressMonitor)new NullProgressMonitor(), countingHandler);
            }
            ++n2;
        }
        return countingHandler.count;
    }

    private void parseProject(IJavaProject prj, IProgressMonitor monitor, ICompilationUnitHandler cuHandler) throws JavaModelException, WsDOMLoadCanceledException {
        IPackageFragment[] iPackageFragmentArray = prj.getPackageFragments();
        int n = iPackageFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment packageFragment = iPackageFragmentArray[n2];
            if (packageFragment.getKind() == 1) {
                ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
                int n3 = iCompilationUnitArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICompilationUnit cu = iCompilationUnitArray[n4];
                    if (monitor != null && monitor.isCanceled()) {
                        throw new WsDOMLoadCanceledException("JAX-WS DOM loading canceled", JaxWsDomRuntimeMessages.WorkspaceCUFinder_LOADING_CANCELED);
                    }
                    cuHandler.handle(cu);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private boolean approve(IJavaProject prj) {
        IProjectSelector[] iProjectSelectorArray = this.selectors;
        int n = this.selectors.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectSelector selector = iProjectSelectorArray[n2];
            if (selector.approve(prj)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected class CountingCUHandler
    implements ICompilationUnitHandler {
        private int count;

        protected CountingCUHandler() {
        }

        @Override
        public void started() {
            this.count = 0;
        }

        @Override
        public void handle(ICompilationUnit cu) {
            ++this.count;
        }

        @Override
        public void finished() {
        }

        @Override
        public void handle(IJavaProject jprj) {
        }
    }
}

