/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.lang.ref.WeakReference;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.ocl.examples.eventmanager.EventManager;
import org.eclipse.ocl.examples.eventmanager.framework.ListenerTypeEnum;
import org.eclipse.ocl.examples.eventmanager.framework.VetoException;

public class AdapterCapsule {
    protected WeakReference<? extends Adapter> _listener = null;
    protected ListenerTypeEnum _listenerType = null;
    protected EventManager _manager;

    public AdapterCapsule(WeakReference<? extends Adapter> listener, ListenerTypeEnum listenerType, EventManager manager) {
        this._listener = listener;
        this._listenerType = listenerType;
        this._manager = manager;
    }

    public WeakReference<? extends Adapter> getListener() {
        return this._listener;
    }

    public boolean isResponsibleFor(Adapter listener, ListenerTypeEnum listenerType) {
        return this._listener != null && this._listener.get() != null && ((Adapter)this._listener.get()).equals(listener) && this._listenerType.matches(listenerType);
    }

    public ListenerTypeEnum getListenerType() {
        return this._listenerType;
    }

    public void deferNotification() {
    }

    public void deliverDeferredEvents() {
    }

    public void cancelDeferment() {
    }

    public void fireEvent(Notification event) {
        ListenerTypeEnum dedicatedListenerType = this.getDedicatedListenerType(event);
        dedicatedListenerType.matches(this._listenerType);
        if (dedicatedListenerType.matches(ListenerTypeEnum.preChange)) {
            try {
                ((Adapter)this._listener.get()).notifyChanged(event);
            }
            catch (VetoException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (dedicatedListenerType.matches(ListenerTypeEnum.postChange)) {
            try {
                ((Adapter)this._listener.get()).notifyChanged(event);
            }
            catch (VetoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private ListenerTypeEnum getDedicatedListenerType(Notification event) {
        return ListenerTypeEnum.postChange;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " for " + this._listenerType.toString();
    }
}

