/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.wst.jsdt.chromium.CallFrame;
import org.eclipse.wst.jsdt.chromium.DebugContext;
import org.eclipse.wst.jsdt.chromium.InvalidContextException;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsScope;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.RestartFrameExtension;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.TextStreamPosition;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ContextBuilder;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.JsEvaluateContextImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ScriptImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ScriptManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandCallbackBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8Helper;
import org.eclipse.wst.jsdt.chromium.internal.v8native.processor.BacktraceProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.V8ProtocolUtil;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FailedCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FrameObject;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.RestartFrameBody;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.ScopeRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessageFactory;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.RestartFrameMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsScopeImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsVariableBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.PropertyReference;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoaderImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;
import org.json.simple.JSONObject;

public class CallFrameImpl
implements CallFrame {
    private final int frameId;
    private final InternalContext context;
    private final FrameObject frameObject;
    private final int lineNumber;
    private final String frameFunction;
    private final long scriptId;
    private final AtomicReference<List<? extends JsScope>> scopesRef = new AtomicReference<Object>(null);
    private final AtomicReference<JsVariable> receiverVariableRef = new AtomicReference<Object>(null);
    private Script script;
    private final JsEvaluateContextImpl evaluateContextImpl = new JsEvaluateContextImpl(){

        @Override
        protected Integer getFrameIdentifier() {
            return CallFrameImpl.this.getIdentifier();
        }

        @Override
        public InternalContext getInternalContext() {
            return CallFrameImpl.this.context;
        }
    };
    private final TextStreamPosition textStreamPosition = new TextStreamPosition(){

        @Override
        public int getOffset() {
            return CallFrameImpl.this.frameObject.position().intValue();
        }

        @Override
        public int getLine() {
            return CallFrameImpl.this.lineNumber;
        }

        @Override
        public int getColumn() {
            Long columnObj = CallFrameImpl.this.frameObject.column();
            if (columnObj == null) {
                return -1;
            }
            return columnObj.intValue();
        }
    };
    public static final RestartFrameExtension RESTART_FRAME_EXTENSION = new RestartFrameExtension(){

        @Override
        public RelayOk restartFrame(CallFrame callFrame, final GenericCallback<Boolean> callback, SyncCallback syncCallback) {
            CallFrameImpl frameImpl = (CallFrameImpl)callFrame;
            final DebugSession debugSession = frameImpl.context.getDebugSession();
            RelaySyncCallback relaySyncCallback = new RelaySyncCallback(syncCallback);
            final RelaySyncCallback.Guard guard = relaySyncCallback.newGuard();
            RestartFrameMessage message = new RestartFrameMessage(frameImpl.frameId);
            V8CommandCallbackBase v8Callback = new V8CommandCallbackBase(){

                @Override
                public void success(SuccessCommandResponse successResponse) {
                    RelayOk relayOk = this.handleRestartResponse(successResponse, debugSession, callback, guard.getRelay());
                    guard.discharge(relayOk);
                }

                @Override
                public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                    if (callback != null) {
                        callback.failure(new Exception(message));
                    }
                }
            };
            try {
                return frameImpl.context.sendV8CommandAsync(message, false, (V8CommandProcessor.V8HandlerCallback)v8Callback, guard.asSyncCallback());
            }
            catch (InternalContext.ContextDismissedCheckedException e) {
                throw new InvalidContextException(e);
            }
        }

        private RelayOk handleRestartResponse(SuccessCommandResponse successResponse, DebugSession debugSession, GenericCallback<Boolean> callback, RelaySyncCallback relaySyncCallback) {
            RestartFrameBody body;
            try {
                body = successResponse.body().asRestartFrameBody();
            }
            catch (JsonProtocolParseException e) {
                throw new RuntimeException(e);
            }
            ContextBuilder.PreContext.UserContextImpl debugContext = debugSession.getContextBuilder().getCurrentDebugContext();
            if (debugContext == null) {
                return this.finishRestartSuccessfully(false, callback, relaySyncCallback);
            }
            body.getResultDescription();
            if (body.getResultDescription().stack_update_needs_step_in() == Boolean.TRUE) {
                return this.stepIn(debugContext, callback, relaySyncCallback);
            }
            return this.reloadStack(debugContext, callback, relaySyncCallback);
        }

        private RelayOk stepIn(InternalContext.UserContext debugContext, final GenericCallback<Boolean> callback, final RelaySyncCallback relaySyncCallback) {
            final RelaySyncCallback.Guard guard = relaySyncCallback.newGuard();
            DebugContext.ContinueCallback continueCallback = new DebugContext.ContinueCallback(){

                @Override
                public void success() {
                    RelayOk relayOk = this.finishRestartSuccessfully(true, callback, relaySyncCallback);
                    guard.discharge(relayOk);
                }

                @Override
                public void failure(String errorMessage) {
                    if (callback != null) {
                        callback.failure(new Exception(errorMessage));
                    }
                }
            };
            return debugContext.continueVm(DebugContext.StepAction.IN, 0, continueCallback, guard.asSyncCallback());
        }

        private RelayOk reloadStack(InternalContext.UserContext debugContext, final GenericCallback<Boolean> callback, final RelaySyncCallback relaySyncCallback) {
            final RelaySyncCallback.Guard guard = relaySyncCallback.newGuard();
            final ContextBuilder.ExpectingBacktraceStep backtraceStep = debugContext.createReloadBacktraceStep();
            V8CommandCallbackBase v8Callback = new V8CommandCallbackBase(){

                @Override
                public void success(SuccessCommandResponse successResponse) {
                    BacktraceProcessor.setFrames(successResponse, backtraceStep);
                    RelayOk relayOk = this.finishRestartSuccessfully(false, callback, relaySyncCallback);
                    guard.discharge(relayOk);
                }

                @Override
                public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                    if (callback != null) {
                        callback.failure(new Exception(message));
                    }
                }
            };
            DebuggerMessage message = DebuggerMessageFactory.backtrace(null, null, true);
            try {
                return debugContext.getInternalContext().sendV8CommandAsync(message, false, (V8CommandProcessor.V8HandlerCallback)v8Callback, guard.asSyncCallback());
            }
            catch (InternalContext.ContextDismissedCheckedException e) {
                throw new InvalidContextException(e);
            }
        }

        private RelayOk finishRestartSuccessfully(boolean vmResumed, GenericCallback<Boolean> callback, RelaySyncCallback relaySyncCallback) {
            if (callback != null) {
                callback.success(vmResumed);
            }
            return relaySyncCallback.finish();
        }

        @Override
        public boolean canRestartFrame(CallFrame callFrame) {
            return callFrame.getScript() != null;
        }
    };
    private static final String DEBUGGER_RESERVED = "debugger";

    public CallFrameImpl(FrameObject frameObject, InternalContext context) {
        long scriptId;
        this.frameObject = frameObject;
        this.context = context;
        int index = (int)frameObject.index();
        JSONObject func = frameObject.func();
        int currentLine = (int)frameObject.line();
        String srcLine = frameObject.sourceLineText();
        if (srcLine.trim().startsWith(DEBUGGER_RESERVED)) {
            ++currentLine;
        }
        Long scriptRef = V8ProtocolUtil.getObjectRef(frameObject.script());
        this.scriptId = scriptId = ScriptImpl.getScriptId(context.getValueLoader().getSpecialHandleManager(), scriptRef).longValue();
        this.lineNumber = currentLine;
        this.frameFunction = V8ProtocolUtil.getFunctionName(func);
        this.frameId = index;
    }

    public InternalContext getInternalContext() {
        return this.context;
    }

    @Override
    public List<? extends JsScope> getVariableScopes() {
        this.ensureScopes();
        return this.scopesRef.get();
    }

    @Override
    public JsVariable getReceiverVariable() throws MethodIsBlockingException {
        this.ensureReceiver();
        return this.receiverVariableRef.get();
    }

    @Override
    public JsEvaluateContext getEvaluateContext() {
        return this.evaluateContextImpl;
    }

    private void ensureScopes() {
        if (this.scopesRef.get() != null) {
            return;
        }
        List<JsScopeImpl<?>> result = Collections.unmodifiableList(this.createScopes());
        this.scopesRef.compareAndSet(null, result);
    }

    private void ensureReceiver() throws MethodIsBlockingException {
        JsVariableBase.Impl result;
        if (this.receiverVariableRef.get() != null) {
            return;
        }
        PropertyReference ref = V8Helper.computeReceiverRef(this.frameObject);
        if (ref == null) {
            result = null;
        } else {
            ValueLoaderImpl valueLoader = this.context.getValueLoader();
            ValueMirror mirror = ((ValueLoader)valueLoader).getOrLoadValueFromRefs(Collections.singletonList(ref)).get(0);
            String varNameStr = ref.getName().toString();
            result = new JsVariableBase.Impl(valueLoader, mirror, varNameStr);
        }
        if (result != null) {
            this.receiverVariableRef.compareAndSet(null, result);
        }
    }

    @Override
    public TextStreamPosition getStatementStartPosition() {
        return this.textStreamPosition;
    }

    @Override
    public String getFunctionName() {
        return this.frameFunction;
    }

    @Override
    public Script getScript() {
        return this.script;
    }

    public int getIdentifier() {
        return this.frameId;
    }

    void hookUpScript(ScriptManager scriptManager) {
        ScriptImpl script = scriptManager.findById(this.scriptId);
        if (script != null) {
            this.script = script;
        }
    }

    private List<JsScopeImpl<?>> createScopes() {
        List<ScopeRef> scopes = this.frameObject.scopes();
        ArrayList result = new ArrayList(scopes.size());
        for (ScopeRef scopeRef : scopes) {
            result.add(JsScopeImpl.create(JsScopeImpl.Host.create(this), scopeRef));
        }
        return result;
    }
}

