/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.Utils;

public class BP1103
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1103(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        MessageEntry request = entryContext.getRequest();
        String requestHeaders = request.getHTTPHeaders();
        String httpStatus = Utils.getHTTPStatusCode(entryContext.getMessageEntry().getHTTPHeaders());
        if (requestHeaders.startsWith("POST ")) {
            this.result = "notApplicable";
        } else if (!"405".equals(httpStatus)) {
            this.result = "warning";
            this.failureDetail = this.validator.createFailureDetail("\nRequest message:\nHeaders:\n" + entryContext.getRequest().getHTTPHeaders() + "\nMessage:\n" + entryContext.getRequest().getMessage() + "\n\nResponse message:\nHeaders:\n" + entryContext.getResponse().getHTTPHeaders() + "\nMessage:\n" + entryContext.getResponse().getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

