/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherExecutionRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.DefaultLauncherExecutionRequest;

@API(status=API.Status.MAINTAINED, since="6.0")
public final class LauncherExecutionRequestBuilder {
    private final @Nullable LauncherDiscoveryRequest discoveryRequest;
    private final @Nullable TestPlan testPlan;
    private final Collection<TestExecutionListener> executionListeners = new ArrayList<TestExecutionListener>();
    private @Nullable CancellationToken cancellationToken;

    public static LauncherExecutionRequestBuilder request(LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notNull((Object)discoveryRequest, (String)"LauncherDiscoveryRequest must not be null");
        return new LauncherExecutionRequestBuilder(discoveryRequest, null);
    }

    public static LauncherExecutionRequestBuilder executionRequest(LauncherDiscoveryRequest discoveryRequest) {
        return LauncherExecutionRequestBuilder.request(discoveryRequest);
    }

    public static LauncherExecutionRequestBuilder request(TestPlan testPlan) {
        Preconditions.notNull((Object)testPlan, (String)"TestPlan must not be null");
        return new LauncherExecutionRequestBuilder(null, testPlan);
    }

    public static LauncherExecutionRequestBuilder executionRequest(TestPlan testPlan) {
        return LauncherExecutionRequestBuilder.request(testPlan);
    }

    private LauncherExecutionRequestBuilder(@Nullable LauncherDiscoveryRequest discoveryRequest, @Nullable TestPlan testPlan) {
        this.discoveryRequest = discoveryRequest;
        this.testPlan = testPlan;
    }

    public LauncherExecutionRequestBuilder listeners(TestExecutionListener ... listeners) {
        Preconditions.notNull((Object)listeners, (String)"TestExecutionListener array must not be null");
        Preconditions.containsNoNullElements((Object[])listeners, (String)"individual listeners must not be null");
        Collections.addAll(this.executionListeners, listeners);
        return this;
    }

    public LauncherExecutionRequestBuilder cancellationToken(CancellationToken cancellationToken) {
        this.cancellationToken = (CancellationToken)Preconditions.notNull((Object)cancellationToken, (String)"CancellationToken must not be null");
        return this;
    }

    public LauncherExecutionRequest build() {
        return new DefaultLauncherExecutionRequest(this.discoveryRequest, this.testPlan, this.executionListeners, Objects.requireNonNullElseGet(this.cancellationToken, CancellationToken::disabled));
    }
}

