/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public abstract class ASTEqualsInitializer
extends ASTNode
implements IASTEqualsInitializer,
IASTAmbiguityParent {
    private IASTInitializerClause fArgument;

    public ASTEqualsInitializer() {
    }

    public ASTEqualsInitializer(IASTInitializerClause arg) {
        this.setInitializerClause(arg);
    }

    @Override
    public IASTInitializerClause getInitializerClause() {
        return this.fArgument;
    }

    @Override
    public void setInitializerClause(IASTInitializerClause clause) {
        this.assertNotFrozen();
        this.fArgument = clause;
        if (clause != null) {
            clause.setParent(this);
            clause.setPropertyInParent(INITIALIZER);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitInitializers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fArgument != null && !this.fArgument.accept(action)) {
            return false;
        }
        return !action.shouldVisitInitializers || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fArgument) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fArgument = (IASTInitializerClause)other;
        }
    }

    @Deprecated
    public IASTExpression getExpression() {
        if (this.fArgument instanceof IASTExpression) {
            return (IASTExpression)this.fArgument;
        }
        return null;
    }

    @Deprecated
    public void setExpression(IASTExpression expression) {
        this.setInitializerClause(expression);
    }
}

