/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.itcl.internal.core.classes.IncrTclClassesManager;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclFieldDeclaration;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclMethodDeclaration;
import org.eclipse.dltk.itcl.internal.core.parser.processors.IncrTclUtils;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.ExtendedTclMethodDeclaration;

public class IncrTclClassCommandProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        if (statement == null || statement != null && statement.getCount() == 0) {
            return null;
        }
        if (statement.getCount() != 3) {
            return null;
        }
        Expression classNameExpr = statement.getAt(1);
        Expression blockExpr = statement.getAt(2);
        if (classNameExpr instanceof SimpleReference && blockExpr instanceof TclBlockExpression) {
            TclBlockExpression block = (TclBlockExpression)blockExpr;
            TypeDeclaration type = new TypeDeclaration(((SimpleReference)classNameExpr).getName(), classNameExpr.sourceStart(), classNameExpr.sourceEnd(), statement.sourceStart(), statement.sourceEnd());
            type.setModifiers(0x400000);
            this.addToParent(parent, (ASTNode)type);
            IncrTclClassesManager.getDefault().add(type.getName());
            List commands = block.parseBlockSimple(false);
            int i = 0;
            while (i < commands.size()) {
                TclStatement st;
                Expression commandName;
                ASTNode nde = (ASTNode)commands.get(i);
                if (nde instanceof TclStatement && (commandName = (st = (TclStatement)nde).getAt(0)) instanceof SimpleReference) {
                    String commandNameStr = ((SimpleReference)commandName).getName();
                    if ("inherit".equals(commandNameStr)) {
                        this.handleInherit(st, type, parser);
                    } else if ("public".equals(commandNameStr)) {
                        this.handleWithModifierSub(st, type, 64, parser);
                    } else if ("protected".equals(commandNameStr)) {
                        this.handleWithModifierSub(st, type, 32, parser);
                    } else if ("private".equals(commandNameStr)) {
                        this.handleWithModifierSub(st, type, 16, parser);
                    } else {
                        this.handleWithModifier(commandNameStr, st, type, 16, parser);
                    }
                }
                ++i;
            }
            return type;
        }
        return null;
    }

    private void handleDestructor(TclStatement statement, TypeDeclaration type, ITclParser parser) {
        if (statement.getCount() != 2) {
            this.report(parser, "Wrong number of arguments", statement.sourceStart(), statement.sourceEnd(), ProblemSeverities.Error);
            this.addToParent((ASTNode)type, (ASTNode)statement);
            return;
        }
        Expression procCode = statement.getAt(1);
        ExtendedTclMethodDeclaration method = new ExtendedTclMethodDeclaration(statement.sourceStart(), statement.sourceEnd());
        method.setName("destructor");
        Expression o = statement.getAt(0);
        method.setNameStart(o.sourceStart());
        method.setNameEnd(o.sourceEnd());
        method.setModifier(0x2400000);
        method.setDeclaringType((ASTNode)type);
        IncrTclUtils.parseBlockAdd(parser, procCode, (MethodDeclaration)method);
        type.getMethodList().add(method);
        this.addToParent((ASTNode)type, (ASTNode)method);
    }

    private void handleWithModifierSub(TclStatement statement, TypeDeclaration type, int modifier, ITclParser parser) {
        TclStatement sub;
        Expression commandName;
        List expressions = statement.getExpressions();
        ArrayList newExpressions = new ArrayList();
        newExpressions.addAll(expressions);
        if (newExpressions.size() > 0) {
            newExpressions.remove(0);
        }
        if ((commandName = (sub = new TclStatement(newExpressions)).getAt(0)) instanceof SimpleReference) {
            this.handleWithModifier(((SimpleReference)commandName).getName(), sub, type, modifier, parser);
        }
    }

    private void handleConstructor(TclStatement statement, TypeDeclaration type, ITclParser parser) {
        if (statement.getCount() < 3) {
            this.report(parser, "Wrong number of arguments", statement.sourceStart(), statement.sourceEnd(), ProblemSeverities.Error);
            this.addToParent((ASTNode)type, (ASTNode)statement);
            return;
        }
        Expression procArguments = statement.getAt(1);
        Expression procCode = null;
        if (statement.getCount() == 3) {
            procCode = statement.getAt(2);
        } else if (statement.getCount() == 4) {
            procCode = statement.getAt(3);
        }
        List arguments = IncrTclUtils.extractMethodArguments(procArguments);
        ExtendedTclMethodDeclaration method = new ExtendedTclMethodDeclaration(statement.sourceStart(), statement.sourceEnd());
        method.setDeclaringType((ASTNode)type);
        method.setName("constructor");
        Expression o = statement.getAt(0);
        method.setNameStart(o.sourceStart());
        method.setNameEnd(o.sourceEnd());
        method.acceptArguments(arguments);
        method.setModifier(0x1400000);
        IncrTclUtils.parseBlockAdd(parser, procCode, (MethodDeclaration)method);
        type.getMethodList().add(method);
        this.addToParent((ASTNode)type, (ASTNode)method);
    }

    private void handleWithModifier(String commandNameStr, TclStatement statement, TypeDeclaration type, int modifier, ITclParser parser) {
        if ("method".equals(commandNameStr)) {
            this.handleMethod(statement, type, modifier, parser);
        } else if ("proc".equals(commandNameStr)) {
            this.handleMethod(statement, type, modifier | 0x800000, parser);
        } else if ("variable".equals(commandNameStr)) {
            this.handleVariable(statement, type, modifier, parser);
        } else if ("common".equals(commandNameStr)) {
            this.handleCommon(statement, type, modifier, parser);
        } else if ("set".equals(commandNameStr)) {
            this.handleSet(statement, type, modifier, parser);
        } else if ("array".equals(commandNameStr)) {
            this.handleArray(statement, type, modifier);
        } else if ("constructor".equals(commandNameStr)) {
            this.handleConstructor(statement, type, parser);
        } else if ("destructor".equals(commandNameStr)) {
            this.handleDestructor(statement, type, parser);
        }
    }

    private void handleSet(TclStatement statement, TypeDeclaration type, int modifier, ITclParser parser) {
        this.processVariable(statement, type, modifier, parser);
    }

    private void processVariable(TclStatement statement, TypeDeclaration type, int modifier, ITclParser parser) {
        if (statement.getCount() < 2) {
            this.report(parser, "Syntax error: at least one argument expected.", (ASTNode)statement, ProblemSeverities.Error);
            return;
        }
        Expression variableName = statement.getAt(1);
        Expression variableValue = null;
        if (statement.getCount() == 3) {
            variableValue = statement.getAt(2);
        }
        if (variableName == null) {
            throw new RuntimeException("empty variable name");
        }
        SimpleReference variable = TclParseUtil.makeVariable((Expression)variableName);
        if (variable != null) {
            IncrTclFieldDeclaration var = new IncrTclFieldDeclaration(variable.getName(), variable.sourceStart(), variable.sourceEnd(), statement.sourceStart(), statement.sourceEnd());
            var.setModifier(0x400000 | modifier);
            var.setDeclaringType(type);
            this.addToParent((ASTNode)type, (ASTNode)var);
            type.getFieldList().add(var);
        }
    }

    private void handleArray(TclStatement statement, TypeDeclaration type, int modifier) {
    }

    private void handleCommon(TclStatement statement, TypeDeclaration type, int modifier, ITclParser parser) {
        if (statement.getCount() < 2) {
            this.report(parser, "Syntax error: one argument expected.", (ASTNode)statement, ProblemSeverities.Error);
            return;
        }
        Expression variableName = statement.getAt(1);
        if (variableName == null) {
            throw new RuntimeException("empty variable name");
        }
        SimpleReference variable = TclParseUtil.makeVariable((Expression)variableName);
        if (variable != null) {
            IncrTclFieldDeclaration var = new IncrTclFieldDeclaration(variable.getName(), variable.sourceStart(), variable.sourceEnd(), statement.sourceStart(), statement.sourceEnd());
            var.setModifier(0x400000 | modifier);
            var.setDeclaringType(type);
            this.addToParent((ASTNode)type, (ASTNode)var);
        }
    }

    private void handleVariable(TclStatement statement, TypeDeclaration type, int modifier, ITclParser parser) {
        this.processVariable(statement, type, modifier, parser);
    }

    private void handleMethod(TclStatement statement, TypeDeclaration type, int modifier, ITclParser parser) {
        if (statement.getCount() < 2) {
            this.report(parser, "Wrong number of arguments", statement.sourceStart(), statement.sourceEnd(), ProblemSeverities.Error);
            this.addToParent((ASTNode)type, (ASTNode)statement);
            return;
        }
        Expression procName = statement.getAt(1);
        String sName = IncrTclUtils.extractMethodName(procName);
        if (sName == null || sName.length() == 0) {
            this.report(parser, "Wrong number of arguments", statement.sourceStart(), statement.sourceEnd(), ProblemSeverities.Error);
            this.addToParent((ASTNode)type, (ASTNode)statement);
            return;
        }
        Expression procArguments = null;
        Expression procCode = null;
        if (statement.getCount() >= 3) {
            procArguments = statement.getAt(2);
        }
        if (statement.getCount() == 4) {
            procCode = statement.getAt(3);
        }
        List arguments = IncrTclUtils.extractMethodArguments(procArguments);
        IncrTclMethodDeclaration method = new IncrTclMethodDeclaration(statement.sourceStart(), statement.sourceEnd());
        method.setName(sName);
        method.setNameStart(procName.sourceStart());
        method.setNameEnd(procName.sourceEnd());
        method.acceptArguments(arguments);
        method.setModifier(0x400000 | modifier);
        method.setDeclaringType((ASTNode)type);
        if ((modifier & 0x800000) != 0) {
            method.setKind(0);
        } else {
            method.setKind(1);
        }
        IncrTclUtils.parseBlockAdd(parser, procCode, (MethodDeclaration)method);
        type.getMethodList().add(method);
        this.addToParent((ASTNode)type, (ASTNode)method);
    }

    private void handleInherit(TclStatement statement, TypeDeclaration type, ITclParser parser) {
        int i = 1;
        while (i < statement.getCount()) {
            Expression expr = statement.getAt(i);
            if (expr instanceof SimpleReference) {
                type.addSuperClass((ASTNode)expr);
            }
            ++i;
        }
    }
}

