/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.IOUtil;

public class LoadLobRequest
extends CDOClientRequest<Boolean> {
    private CDOLobInfo info;
    private Object outputStreamOrWriter;

    public LoadLobRequest(CDOClientProtocol protocol, CDOLobInfo info, Object outputStreamOrWriter) {
        super(protocol, (short)47);
        this.info = info;
        this.outputStreamOrWriter = outputStreamOrWriter;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeByteArray(this.info.getID());
    }

    @Override
    protected Boolean confirming(ExtendedDataInputStream in) throws Exception {
        try {
            if (this.outputStreamOrWriter instanceof OutputStream) {
                IOUtil.copyBinary((InputStream)in, (OutputStream)((OutputStream)this.outputStreamOrWriter), (long)this.info.getSize());
            } else {
                IOUtil.copyCharacter((Reader)new InputStreamReader((InputStream)in), (Writer)((Writer)this.outputStreamOrWriter), (long)this.info.getSize());
            }
        }
        finally {
            ((Closeable)this.outputStreamOrWriter).close();
        }
        return true;
    }

    @Override
    protected Boolean confirming(CDODataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }
}

