/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.ExternalReferenceManager;
import org.eclipse.emf.cdo.server.internal.db.mapping.CoreTypeMappings;
import org.eclipse.emf.cdo.spi.server.LongIDStore;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class LongIDHandler
extends Lifecycle
implements IIDHandler {
    public static final CDOID MIN = CDOID.NULL;
    public static final CDOID MAX = LongIDHandler.create(Long.MAX_VALUE);
    private DBStore store;
    private ExternalReferenceManager externalReferenceManager;
    private CDOID lastObjectID = MIN;
    private CDOID nextLocalObjectID = MAX;

    public LongIDHandler(DBStore store) {
        this.store = store;
        this.externalReferenceManager = new ExternalReferenceManager(store);
    }

    @Override
    public DBStore getStore() {
        return this.store;
    }

    @Override
    public Set<CDOID.ObjectType> getObjectIDTypes() {
        return LongIDStore.OBJECT_ID_TYPES;
    }

    @Override
    public CDOID getMinCDOID() {
        return MIN;
    }

    @Override
    public CDOID getMaxCDOID() {
        return MAX;
    }

    @Override
    public int compare(CDOID id1, CDOID id2) {
        return id1.compareTo((Object)id2);
    }

    @Override
    public CDOID createCDOID(String val) {
        Long id = Long.valueOf(val);
        return LongIDHandler.create(id);
    }

    @Override
    public synchronized CDOID getLastObjectID() {
        return this.lastObjectID;
    }

    @Override
    public synchronized void setLastObjectID(CDOID lastObjectID) {
        this.lastObjectID = lastObjectID;
    }

    @Override
    public synchronized void adjustLastObjectID(CDOID maxID) {
        if (this.compare(maxID, this.lastObjectID) > 0) {
            this.lastObjectID = maxID;
        }
    }

    @Override
    public synchronized CDOID getNextLocalObjectID() {
        return this.nextLocalObjectID;
    }

    @Override
    public synchronized void setNextLocalObjectID(CDOID nextLocalObjectID) {
        this.nextLocalObjectID = nextLocalObjectID;
    }

    @Override
    public synchronized CDOID getNextCDOID(CDORevision revision) {
        if (revision.getBranch().isLocal()) {
            CDOID result = this.nextLocalObjectID;
            this.nextLocalObjectID = LongIDHandler.create(LongIDHandler.value(result) - 1L);
            return result;
        }
        this.lastObjectID = LongIDHandler.create(LongIDHandler.value(this.lastObjectID) + 1L);
        return this.lastObjectID;
    }

    @Override
    @Deprecated
    public boolean isLocalCDOID(CDOID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBType getDBType() {
        return DBType.BIGINT;
    }

    @Override
    public ITypeMapping getObjectTypeMapping() {
        return new CoreTypeMappings.TMObject();
    }

    @Override
    public void appendCDOID(StringBuilder builder, CDOID id) {
        long value;
        if (id != null && id.isExternal()) {
            IDBStoreAccessor accessor = (IDBStoreAccessor)StoreThreadLocal.getAccessor();
            String uri = CDOIDUtil.getString((CDOID)id);
            value = this.externalReferenceManager.lookupByURI(accessor, uri);
        } else {
            value = LongIDHandler.value(id);
        }
        builder.append(value);
    }

    @Override
    public void setCDOIDRaw(PreparedStatement stmt, int column, Object rawID) throws SQLException {
        stmt.setLong(column, (Long)rawID);
    }

    @Override
    public void setCDOID(PreparedStatement stmt, int column, CDOID id) throws SQLException {
        this.setCDOID(stmt, column, id, -1L);
    }

    @Override
    public void setCDOID(PreparedStatement stmt, int column, CDOID id, long commitTime) throws SQLException {
        long value;
        if (id != null && id.getType() == CDOID.Type.EXTERNAL_OBJECT) {
            if (commitTime == -1L) {
                IStoreAccessor.CommitContext commitContext = StoreThreadLocal.getCommitContext();
                commitTime = commitContext != null ? commitContext.getBranchPoint().getTimeStamp() : 0L;
            }
            value = this.externalReferenceManager.mapExternalReference((CDOIDExternal)id, commitTime);
        } else {
            value = LongIDHandler.value(id);
        }
        stmt.setLong(column, value);
    }

    @Override
    public CDOID getCDOID(ResultSet resultSet, int column) throws SQLException {
        long id = resultSet.getLong(column);
        if (resultSet.wasNull()) {
            return null;
        }
        return this.unmapExternalReference(id);
    }

    @Override
    public CDOID getCDOID(ResultSet resultSet, String name) throws SQLException {
        long id = resultSet.getLong(name);
        if (resultSet.wasNull()) {
            return null;
        }
        return this.unmapExternalReference(id);
    }

    private CDOID unmapExternalReference(long id) {
        if (id < 0L) {
            return this.externalReferenceManager.unmapExternalReference(id);
        }
        return LongIDHandler.create(id);
    }

    @Override
    public String getStringValue(ResultSet resultSet, int column) throws SQLException {
        long id = resultSet.getLong(column);
        if (resultSet.wasNull()) {
            return "null";
        }
        return Long.toString(id);
    }

    @Override
    public CDOID mapURI(IDBStoreAccessor accessor, String uri, long commitTime) {
        return LongIDHandler.create(this.externalReferenceManager.mapURI(accessor, uri, commitTime));
    }

    @Override
    public String unmapURI(IDBStoreAccessor accessor, CDOID id) {
        if (id != null && id.getType() == CDOID.Type.EXTERNAL_OBJECT) {
            return ((CDOIDExternal)id).getURI();
        }
        return this.externalReferenceManager.unmapURI(accessor, LongIDHandler.value(id));
    }

    @Override
    public boolean deleteURIMapping(Statement statement, String uri) {
        return this.externalReferenceManager.deleteByURI(statement, uri);
    }

    @Override
    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        this.externalReferenceManager.rawExport(connection, out, fromCommitTime, toCommitTime);
    }

    @Override
    public void rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        this.externalReferenceManager.rawImport(connection, in, fromCommitTime, toCommitTime, monitor);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.externalReferenceManager.activate();
    }

    protected void doDeactivate() throws Exception {
        this.externalReferenceManager.deactivate();
        super.doDeactivate();
    }

    private static CDOID create(long id) {
        return CDOIDUtil.createLong((long)id);
    }

    private static long value(CDOID id) {
        return CDOIDUtil.getLong((CDOID)id);
    }
}

