/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ExposeHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.editor.GFFigureCanvas;
import org.eclipse.graphiti.ui.internal.editor.GraphitiScrollingGraphicalViewer;
import org.eclipse.graphiti.ui.internal.fixed.FixedScalableRootEditPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GFScrollingGraphicalViewer
extends GraphitiScrollingGraphicalViewer {
    IFigure rootFigure;

    public GFScrollingGraphicalViewer(DiagramBehavior diagramBehavior) {
        super(diagramBehavior);
    }

    protected void createDefaultRoot() {
        this.setRootEditPart((RootEditPart)new FixedScalableRootEditPart());
    }

    public final Control createGFControl(Composite parent) {
        GFFigureCanvas canvas = new GFFigureCanvas(parent, this.getLightweightSystem(), this.getDiagramBehavior());
        canvas.setData(new String("name"), ((Object)((Object)canvas)).getClass().toString());
        this.setControl((Control)canvas);
        this.installRootFigure();
        return canvas;
    }

    private void installRootFigure() {
        if (this.getGFFigureCanvas() == null) {
            return;
        }
        if (this.rootFigure instanceof Viewport) {
            this.getGFFigureCanvas().setViewport((Viewport)this.rootFigure);
        } else {
            this.getGFFigureCanvas().setContents(this.rootFigure);
        }
    }

    protected GFFigureCanvas getGFFigureCanvas() {
        return (GFFigureCanvas)this.getControl();
    }

    protected void setRootFigure(IFigure figure) {
        this.rootFigure = figure;
        this.installRootFigure();
    }

    public void reveal(EditPart part) {
        if (part == null) {
            return;
        }
        EditPart current = part.getParent();
        while (current != null) {
            ExposeHelper helper = (ExposeHelper)current.getAdapter(ExposeHelper.class);
            if (helper != null) {
                helper.exposeDescendant(part);
            }
            current = current.getParent();
        }
        AccessibleEditPart acc = (AccessibleEditPart)part.getAdapter(AccessibleEditPart.class);
        if (acc != null) {
            this.getControl().getAccessible().setFocus(acc.getAccessibleID());
        }
        Viewport port = this.getGFFigureCanvas().getViewport();
        IFigure target = ((GraphicalEditPart)part).getFigure();
        Rectangle exposeRegion = target.getBounds().getCopy();
        target = target.getParent();
        while (target != null && target != port) {
            target.translateToParent((Translatable)exposeRegion);
            target = target.getParent();
        }
        exposeRegion.expand(5, 5);
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
        Point finalLocation = new Point();
        finalLocation.x = viewportSize.width < exposeRegion.width ? Math.min(bottomRight.x, Math.max(topLeft.x, port.getViewLocation().x)) : Math.min(topLeft.x, Math.max(bottomRight.x, port.getViewLocation().x));
        finalLocation.y = viewportSize.height < exposeRegion.height ? Math.min(bottomRight.y, Math.max(topLeft.y, port.getViewLocation().y)) : Math.min(topLeft.y, Math.max(bottomRight.y, port.getViewLocation().y));
        this.getGFFigureCanvas().scrollSmoothTo(finalLocation.x, finalLocation.y);
    }
}

