/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CorrectPackageDeclarationFixCore
implements IProposableFix {
    private final ICompilationUnit fCompilationUnit;
    private final IProblemLocation fLocation;

    private CorrectPackageDeclarationFixCore(CompilationUnit compilationUnit, IProblemLocation location) {
        this.fCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        this.fLocation = location;
    }

    public static CorrectPackageDeclarationFixCore create(CompilationUnit cu, IProblemLocation location) {
        if (!CorrectPackageDeclarationFixCore.isValidProposal((ICompilationUnit)cu.getJavaElement())) {
            return null;
        }
        return new CorrectPackageDeclarationFixCore(cu, location);
    }

    private static boolean isValidProposal(ICompilationUnit cu) {
        boolean isValid;
        block5: {
            isValid = true;
            IPackageFragment parentPack = (IPackageFragment)cu.getParent();
            try {
                IJavaProject jProject;
                IPackageDeclaration[] decls = cu.getPackageDeclarations();
                if (!parentPack.isDefaultPackage() || decls.length <= 0 || (jProject = parentPack.getJavaProject()) == null || !JavaModelUtil.is9OrHigher(jProject)) break block5;
                try {
                    IModuleDescription desc = jProject.getModuleDescription();
                    if (desc != null && desc.exists()) {
                        isValid = false;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
        return isValid;
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        IPackageFragment parentPack = (IPackageFragment)this.fCompilationUnit.getParent();
        IPackageDeclaration[] decls = this.fCompilationUnit.getPackageDeclarations();
        CompilationUnitChange change = new CompilationUnitChange(this.getDisplayString(), this.fCompilationUnit);
        MultiTextEdit root = new MultiTextEdit();
        if (parentPack.isDefaultPackage() && decls.length > 0) {
            IPackageDeclaration[] iPackageDeclarationArray = decls;
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageDeclaration decl = iPackageDeclarationArray[n2];
                ISourceRange range = decl.getSourceRange();
                root.addChild((TextEdit)new DeleteEdit(range.getOffset(), range.getLength()));
                ++n2;
            }
        } else if (!parentPack.isDefaultPackage() && decls.length == 0) {
            String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)this.fCompilationUnit);
            String str = "package " + parentPack.getElementName() + ";" + lineDelim + lineDelim;
            root.addChild((TextEdit)new InsertEdit(0, str));
        } else {
            root.addChild((TextEdit)new ReplaceEdit(this.fLocation.getOffset(), this.fLocation.getLength(), parentPack.getElementName()));
        }
        change.setEdit((TextEdit)root);
        return change;
    }

    @Override
    public String getDisplayString() {
        return CorrectionMessages.CorrectPackageDeclarationProposal_name;
    }

    @Override
    public String getAdditionalProposalInfo() {
        return null;
    }

    @Override
    public IStatus getStatus() {
        return null;
    }
}

