/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIImageDescriptor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryContentProvider;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryStandin;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class LibraryLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        String key = null;
        IStatus status = Status.OK_STATUS;
        if (element instanceof LibraryStandin) {
            LibraryStandin library = (LibraryStandin)element;
            IPath sourcePath = library.getSystemLibrarySourcePath();
            key = sourcePath != null && !Path.EMPTY.equals((Object)sourcePath) ? "org.eclipse.jdt.ui.jar_lsrc_obj.gif" : "org.eclipse.jdt.ui.jar_l_obj.gif";
            status = library.validate();
        } else if (element instanceof LibraryContentProvider.SubElement) {
            switch (((LibraryContentProvider.SubElement)element).getType()) {
                case 2: {
                    key = "org.eclipse.jdt.ui.jar_src_obj.gif";
                    break;
                }
                case 3: {
                    key = "org.eclipse.jdt.ui.external_annotation_location_attrib.gif";
                    break;
                }
                default: {
                    key = "org.eclipse.jdt.ui.jdoc_tag_obj.gif";
                }
            }
        }
        if (key != null) {
            if (!status.isOK()) {
                ImageDescriptor base = JavaUI.getSharedImages().getImageDescriptor(key);
                JDIImageDescriptor descriptor = new JDIImageDescriptor(base, 1);
                return JDIDebugUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
            }
            return JavaUI.getSharedImages().getImage(key);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof LibraryStandin) {
            return ((LibraryStandin)element).getSystemLibraryPath().toOSString();
        }
        if (element instanceof LibraryContentProvider.SubElement) {
            LibraryContentProvider.SubElement subElement = (LibraryContentProvider.SubElement)element;
            StringBuilder text = new StringBuilder();
            switch (subElement.getType()) {
                case 2: {
                    text.append(JREMessages.VMLibraryBlock_0);
                    IPath systemLibrarySourcePath = subElement.getParent().getSystemLibrarySourcePath();
                    if (systemLibrarySourcePath != null && !Path.EMPTY.equals((Object)systemLibrarySourcePath)) {
                        text.append(systemLibrarySourcePath.toOSString());
                        break;
                    }
                    text.append(JREMessages.VMLibraryBlock_1);
                    break;
                }
                case 1: {
                    text.append(JREMessages.LibraryLabelProvider_0);
                    URL javadocLocation = subElement.getParent().getJavadocLocation();
                    if (javadocLocation != null) {
                        text.append(javadocLocation.toExternalForm());
                        break;
                    }
                    text.append(JREMessages.VMLibraryBlock_1);
                    break;
                }
                case 3: {
                    text.append(JREMessages.VMExternalAnnsBlock_1);
                    IPath externalAnnotationsPath = subElement.getParent().getExternalAnnotationsPath();
                    if (externalAnnotationsPath != null && !Path.EMPTY.equals((Object)externalAnnotationsPath)) {
                        text.append(externalAnnotationsPath.toOSString());
                        break;
                    }
                    text.append(JREMessages.VMExternalAnnsBlock_2);
                    break;
                }
            }
            return text.toString();
        }
        return null;
    }
}

