/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.java.IJSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.core.internal.modelhandler.ModelHandlerForJSP;
import org.eclipse.text.edits.CopySourceEdit;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSPTranslationUtil {
    protected IDocument fDocument = null;
    protected JSPTranslationExtension fTranslation = null;

    public JSPTranslationUtil(IDocument document) {
        this.fDocument = document;
    }

    public TextEdit translateTextEdit(TextEdit textEdit) {
        MultiTextEdit translatedTextEdit = null;
        int javaOffset = textEdit.getOffset();
        int jspOffset = this.getTranslation().getJspOffset(textEdit.getOffset());
        int length = textEdit.getLength();
        if (textEdit instanceof MultiTextEdit) {
            translatedTextEdit = new MultiTextEdit();
            TextEdit[] children = ((MultiTextEdit)textEdit).getChildren();
            int i = 0;
            while (i < children.length) {
                TextEdit translatedChildTextEdit = this.translateTextEdit(children[i]);
                if (translatedChildTextEdit != null) {
                    translatedTextEdit.addChild(translatedChildTextEdit);
                }
                ++i;
            }
        } else if (textEdit instanceof ReplaceEdit) {
            if (jspOffset == -1) {
                return null;
            }
            if (!this.getTranslation().javaSpansMultipleJspPartitions(javaOffset, length)) {
                translatedTextEdit = new ReplaceEdit(jspOffset, length, ((ReplaceEdit)textEdit).getText());
            }
        } else if (textEdit instanceof InsertEdit) {
            translatedTextEdit = new InsertEdit(jspOffset, ((InsertEdit)textEdit).getText());
        } else if (textEdit instanceof DeleteEdit) {
            translatedTextEdit = new DeleteEdit(jspOffset, length);
            TextEdit[] children = ((DeleteEdit)textEdit).getChildren();
            int i = 0;
            while (i < children.length) {
                TextEdit translatedChildTextEdit = this.translateTextEdit(children[i]);
                if (translatedChildTextEdit != null) {
                    ((DeleteEdit)translatedTextEdit).addChild(translatedChildTextEdit);
                }
                ++i;
            }
        } else if (textEdit instanceof CopySourceEdit) {
            translatedTextEdit = new CopySourceEdit(jspOffset, length);
            ((CopySourceEdit)translatedTextEdit).setTargetEdit(((CopySourceEdit)textEdit).getTargetEdit());
            ((CopySourceEdit)translatedTextEdit).setSourceModifier(((CopySourceEdit)textEdit).getSourceModifier());
        } else if (textEdit instanceof CopyTargetEdit) {
            translatedTextEdit = new CopyTargetEdit(jspOffset);
            ((CopyTargetEdit)textEdit).getSourceEdit().setTargetEdit((CopyTargetEdit)translatedTextEdit);
        } else if (textEdit instanceof MoveSourceEdit) {
            translatedTextEdit = new MoveSourceEdit(jspOffset, length);
            ((MoveSourceEdit)translatedTextEdit).setTargetEdit(((MoveSourceEdit)textEdit).getTargetEdit());
        } else if (textEdit instanceof MoveTargetEdit) {
            translatedTextEdit = new MoveTargetEdit(jspOffset);
            ((MoveTargetEdit)textEdit).getSourceEdit().setTargetEdit((MoveTargetEdit)translatedTextEdit);
        } else {
            System.out.println("Need to translate " + String.valueOf(textEdit));
        }
        return translatedTextEdit;
    }

    public JSPTranslationExtension getTranslation() {
        if (this.fTranslation == null) {
            IDOMModel xmlModel = (IDOMModel)this.getModelManager().getExistingModelForRead(this.fDocument);
            ModelHandlerForJSP.ensureTranslationAdapterFactory((IStructuredModel)xmlModel);
            try {
                IDOMDocument xmlDoc = xmlModel.getDocument();
                JSPTranslationAdapter translationAdapter = (JSPTranslationAdapter)xmlDoc.getAdapterFor(IJSPTranslation.class);
                if (translationAdapter != null) {
                    this.fTranslation = translationAdapter.getJSPTranslation();
                }
            }
            finally {
                if (xmlModel != null) {
                    xmlModel.releaseFromRead();
                }
            }
        }
        return this.fTranslation;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.getTranslation().getCompilationUnit();
    }

    protected IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }
}

