/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ocl.metainfo;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.m2m.internal.qvt.oml.ocl.Logger;
import org.eclipse.m2m.internal.qvt.oml.ocl.metainfo.OclMetainfo;
import org.eclipse.m2m.internal.qvt.oml.ocl.metainfo.OclMetainfoOperation;

public class OclMetainfoClassLazyLoader
implements OclMetainfo.LazyLoader {
    private final Class<?> myMetainfoClass;
    private final Class<?> myExecutableClass;

    public OclMetainfoClassLazyLoader(Class<?> executableClass) {
        this(executableClass, OclMetainfoClassLazyLoader.getInnerClassByName(executableClass, "Metainfo"));
    }

    protected OclMetainfoClassLazyLoader(Class<?> executableClass, Class<?> metainfoClass) {
        this.myExecutableClass = executableClass;
        this.myMetainfoClass = metainfoClass;
    }

    @Override
    public void loadOperations(List<OclMetainfoOperation> operations) {
        Method[] methods = this.myMetainfoClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (OclMetainfoClassLazyLoader.isObjectMethod(methods[i])) {
                Logger.logInfo("Skipping method: " + methods[i].getName() + " since belongs to Object");
            } else if (!Modifier.isPublic(methods[i].getModifiers())) {
                Logger.logInfo("Skipping method: " + methods[i].getName() + " since it is not public");
            } else {
                Method execMethod = null;
                Exception ex = null;
                try {
                    execMethod = this.myExecutableClass.getMethod(methods[i].getName(), methods[i].getParameterTypes());
                }
                catch (SecurityException e) {
                    ex = e;
                }
                catch (NoSuchMethodException e) {
                    ex = e;
                }
                if (execMethod == null) {
                    Logger.logError("No executable found for " + methods[i].getName(), ex);
                } else {
                    OclMetainfoOperation operation = OclMetainfoClassLazyLoader.buildOperation(methods[i], execMethod);
                    if (operation != null) {
                        operations.add(operation);
                    }
                }
            }
            ++i;
        }
    }

    protected OclMetainfo buildImportedMetainfo(Class<?> metainfoClass) {
        Class<?> executableClass = OclMetainfoClassLazyLoader.getExecutableClass(metainfoClass);
        return new OclMetainfo(new OclMetainfoClassLazyLoader(executableClass, metainfoClass));
    }

    protected static Class<?> getExecutableClass(Class<?> metainfoClass) {
        Class<?> executableClass = metainfoClass.getDeclaringClass();
        if (executableClass == null) {
            Logger.logError("Class '" + metainfoClass.getName() + "' is not inner");
            return null;
        }
        return executableClass;
    }

    public Class<?> getMetainfoClass() {
        return this.myMetainfoClass;
    }

    private static OclMetainfoOperation buildOperation(Method declMethod, Method execMethod) {
        String[] value;
        if (!Modifier.isStatic(declMethod.getModifiers())) {
            Logger.logError("Method '" + declMethod.getName() + "' must be static");
            return null;
        }
        if (declMethod.getReturnType() != String[].class) {
            Logger.logError("Method '" + declMethod.getName() + "' must return 'String[]'");
            return null;
        }
        try {
            value = (String[])declMethod.invoke(null, new Object[declMethod.getParameterTypes().length]);
        }
        catch (Exception e) {
            Logger.logError("Unable to run method '" + declMethod.getName() + "'", e);
            return null;
        }
        if (value.length < 2) {
            Logger.logError("An array returned by '" + declMethod.getName() + "' must have at leat two elements: context type and result type");
            return null;
        }
        OclMetainfoOperation operation = new OclMetainfoOperation(value[0], value[value.length - 1], declMethod.getName(), execMethod);
        int i = 1;
        while (i < value.length - 1) {
            operation.getParameterTypes().add(value[i]);
            ++i;
        }
        return operation;
    }

    protected static Class<?> getInnerClassByName(Class<?> cl, String name) {
        Class<?>[] innerClasses = cl.getClasses();
        Class<?> result = null;
        int i = 0;
        while (i < innerClasses.length) {
            if (name.equals(innerClasses[i].getSimpleName())) {
                result = innerClasses[i];
                break;
            }
            ++i;
        }
        return result;
    }

    private static boolean isObjectMethod(Method method) {
        try {
            Method objectMethod = Object.class.getMethod(method.getName(), method.getParameterTypes());
            return objectMethod != null;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }
}

