/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class EasyToolBarDropDown
extends Action
implements IMenuCreator {
    private IStatusLineManager statusLineManager;
    private ToolBar toolBar;
    private Menu menu;

    public EasyToolBarDropDown(String text, ImageDescriptor image, AbstractEditorPane pane) {
        this(text, image, pane.getEditor());
    }

    public EasyToolBarDropDown(String text, ImageDescriptor image, MultiPaneEditor editor) {
        super(text, image);
        this.toolBar = editor.getToolBarManager().getControl();
        this.statusLineManager = editor.getEditorSite().getActionBars().getStatusLineManager();
        this.setMenuCreator(this);
    }

    public final void run() {
        ToolItem myself = null;
        ToolItem[] toolItemArray = this.toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            if (item != null && item.getData() != null && item.getData() instanceof ActionContributionItem && ((ActionContributionItem)item.getData()).getAction() == this) {
                myself = item;
                break;
            }
            ++n2;
        }
        if (myself == null) {
            return;
        }
        Menu m = this.getMenu((Control)myself.getParent());
        Rectangle b = myself.getBounds();
        Point p = myself.getParent().toDisplay(new Point(b.x, b.y + b.height));
        m.setLocation(p.x, p.y);
        m.setVisible(true);
    }

    public abstract void contribute(PopupMenu var1);

    public final void dispose() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
    }

    public final Menu getMenu(Control parent) {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        PopupMenu popup = new PopupMenu();
        this.contribute(popup);
        this.menu = popup.createMenu(this.statusLineManager, parent);
        return this.menu;
    }

    public final Menu getMenu(Menu parent) {
        return null;
    }
}

