/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.dialogs;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ErrorsDialog
extends Dialog {
    private static final int INITIAL_WIDTH = 600;
    private static final int INITIAL_HEIGHT = 600;
    private final Diagnostic fDiagnostic;

    public ErrorsDialog(Shell parentShell, Diagnostic diagnostic) {
        super(parentShell);
        this.fDiagnostic = diagnostic;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ErrorsDialog_errors);
        newShell.setImage(ImageProvider.getInstance().getMoDiscoIcon());
        IDialogSettings dialogBoundsSettings = this.getDialogBoundsSettings();
        if (dialogBoundsSettings.get("DIALOG_WIDTH") == null) {
            Rectangle parent = this.getParentShell().getBounds();
            newShell.setBounds(parent.x + parent.width / 2 - 300, parent.y + parent.height / 2 - 300, 600, 600);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        SashForm sashForm = new SashForm(composite, 0);
        sashForm.setOrientation(512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewer treeViewer = new TreeViewer((Composite)sashForm, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        treeViewer.getControl().setLayoutData((Object)gridData);
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                Diagnostic diagnostic = (Diagnostic)parentElement;
                return diagnostic.getChildren().toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                Diagnostic diagnostic = (Diagnostic)element;
                return !diagnostic.getChildren().isEmpty();
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Diagnostic diagnostic = (Diagnostic)element;
                return diagnostic.getMessage();
            }

            public Image getImage(Object element) {
                Diagnostic diagnostic = (Diagnostic)element;
                int severity = diagnostic.getSeverity();
                if (severity == 2) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                }
                if (severity == 4) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
                if (severity == 1) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                }
                return null;
            }
        });
        treeViewer.setInput((Object)this.fDiagnostic);
        final Text text = new Text((Composite)sashForm, 2890);
        GridData gridData2 = new GridData(4, 4, true, true);
        text.setLayoutData((Object)gridData2);
        sashForm.setWeights(new int[]{2, 1});
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    text.setText("");
                    return;
                }
                Diagnostic diagnostic = (Diagnostic)selection.getFirstElement();
                StringBuilder builder = new StringBuilder();
                if (diagnostic.getMessage() != null) {
                    builder.append(diagnostic.getMessage());
                }
                text.setText(builder.toString());
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = ((Object)((Object)this)).getClass().getName() + ".settings";
        IDialogSettings settings = MoDiscoBrowserPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }
}

