/*******************************************************************************
 * Copyright (c) 2020, 2023 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   E.D.Willink - initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.xtext.base.serializer;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

/**
 * A RuleMatch identifies some common expression evaluation functionality for constant folding by the compile-time StaticRuleMatch
 * and full evaluation by the run-time DynamicRuleMatch.
 */
public interface RuleMatch
{
	/**#
	 * Return the known integer value of cardinalityVariable if known, or null if not yet knowable.
	 */
	@Nullable Integer basicGetIntegerSolution(int cardinalityVariableIndex);

	/**
	 * Return the number of eAttribute slot elements in the user model element. For a non-NullEnumerationValue, the
	 * number of slot elements that match known enumerationValue elements is returned. Returns null if not yet computable.
	 */
	@Nullable Integer getSize(@NonNull EStructuralFeature eStructuralFeature);

	/**
	 * Return the number of eAttribute slot elements in the user model element. For a non-NullEnumerationValue, the
	 * number of slot elements that match known enumerationValue elements is returned. Returns null if not yet computable.
	 */
	@Nullable Integer getSize(@NonNull EAttribute eAttribute, @NonNull EnumerationValue enumerationValue);

	/**
	 * Return the number of eStructuralFeature slot elements in the user model element that may be generated by any
	 * of the gramm rules identified by grammarRuleVector.
	 */
	@Nullable Integer getSize(@NonNull EReference eReference, @NonNull GrammarRuleVector grammarRuleVector);
}