/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IExceptionAttribute;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.osgi.framework.BundleException;

public class PackageFinder {
    public static Set<String> findPackagesInClassFiles(IClassFile[] files, IProgressMonitor monitor) {
        HashSet<String> packages = new HashSet<String>();
        monitor.beginTask(PDEUIMessages.PackageFinder_taskName, files.length);
        IClassFile[] iClassFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IClassFile file = iClassFileArray[n2];
            IClassFileReader reader = ToolFactory.createDefaultClassFileReader((IClassFile)file, (int)65535);
            if (reader != null) {
                PackageFinder.computeReferencedTypes(reader, packages);
            }
            monitor.worked(1);
            ++n2;
        }
        return packages;
    }

    static void computeReferencedTypes(IClassFileReader cfr, Set<String> packages) {
        IMethodInfo[] methodInfos;
        Object fieldName;
        IFieldInfo[] fieldInfos;
        char[] scn;
        char[][] interfaces = cfr.getInterfaceNames();
        if (interfaces != null) {
            char[][] cArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                char[] interfaceName = cArray[n2];
                packages.add(PackageFinder.getPackage(new String(interfaceName).replace('/', '.')));
                ++n2;
            }
        }
        if ((scn = cfr.getSuperclassName()) != null) {
            packages.add(PackageFinder.getPackage(new String(scn).replace('/', '.')));
        }
        IFieldInfo[] iFieldInfoArray = fieldInfos = cfr.getFieldInfos();
        int n = fieldInfos.length;
        int n3 = 0;
        while (n3 < n) {
            IFieldInfo fieldInfo = iFieldInfoArray[n3];
            fieldName = new String(fieldInfo.getDescriptor());
            if (!PackageFinder.isPrimitiveTypeSignature((String)fieldName)) {
                String fieldDescriptor = PackageFinder.extractFullyQualifiedTopLevelType((String)fieldName);
                packages.add(PackageFinder.getPackage(fieldDescriptor));
            }
            ++n3;
        }
        fieldName = methodInfos = cfr.getMethodInfos();
        int n4 = methodInfos.length;
        n = 0;
        while (n < n4) {
            IMethodInfo methodInfo = fieldName[n];
            IExceptionAttribute exceptionAttribute = methodInfo.getExceptionAttribute();
            if (exceptionAttribute != null) {
                char[][] exceptionNames;
                char[][] cArray = exceptionNames = exceptionAttribute.getExceptionNames();
                int n5 = exceptionNames.length;
                int n6 = 0;
                while (n6 < n5) {
                    char[] exceptionName = cArray[n6];
                    packages.add(PackageFinder.getPackage(new String(exceptionName).replace('/', '.')));
                    ++n6;
                }
            }
            String descriptor = new String(methodInfo.getDescriptor());
            String[] parameterTypes = Signature.getParameterTypes((String)descriptor);
            int j = 0;
            while (j < parameterTypes.length) {
                if (!PackageFinder.isPrimitiveTypeSignature(parameterTypes[j])) {
                    packages.add(PackageFinder.getPackage(PackageFinder.extractFullyQualifiedTopLevelType(parameterTypes[j])));
                }
                ++j;
            }
            String returnType = Signature.getReturnType((String)descriptor);
            if (!PackageFinder.isPrimitiveTypeSignature(returnType)) {
                returnType = PackageFinder.extractFullyQualifiedTopLevelType(returnType);
                packages.add(PackageFinder.getPackage(returnType));
            }
            ++n;
        }
        IConstantPool pool = cfr.getConstantPool();
        int length = pool.getConstantPoolCount();
        int i = 1;
        while (i < length) {
            switch (pool.getEntryKind(i)) {
                case 7: {
                    IConstantPoolEntry entry = pool.decodeEntry(i);
                    String className = new String(entry.getClassInfoName()).replace('/', '.');
                    className = className.indexOf(59) >= 0 ? PackageFinder.extractFullyQualifiedTopLevelType(className) : className;
                    packages.add(PackageFinder.getPackage(className));
                    break;
                }
                case 12: {
                    IConstantPoolEntry entry = pool.decodeEntry(i);
                    int descIndex = entry.getNameAndTypeInfoDescriptorIndex();
                    if (pool.getEntryKind(descIndex) != 1) break;
                    entry = pool.decodeEntry(descIndex);
                    char[] type = entry.getUtf8Value();
                    if (type[0] == '(') {
                        String descriptor = new String(type);
                        String[] parameterTypes = Signature.getParameterTypes((String)descriptor);
                        int j = 0;
                        while (j < parameterTypes.length) {
                            if (!PackageFinder.isPrimitiveTypeSignature(parameterTypes[j])) {
                                packages.add(PackageFinder.getPackage(PackageFinder.extractFullyQualifiedTopLevelType(parameterTypes[j])));
                            }
                            ++j;
                        }
                        String returnType = Signature.getReturnType((String)descriptor);
                        if (PackageFinder.isPrimitiveTypeSignature(returnType)) break;
                        returnType = PackageFinder.extractFullyQualifiedTopLevelType(returnType);
                        packages.add(PackageFinder.getPackage(returnType));
                        break;
                    }
                    String typeString = new String(type);
                    if (PackageFinder.isPrimitiveTypeSignature(typeString)) break;
                    packages.add(PackageFinder.getPackage(PackageFinder.extractFullyQualifiedTopLevelType(typeString)));
                }
            }
            ++i;
        }
        packages.remove("");
    }

    static boolean isPrimitiveTypeSignature(String typeSig) {
        if (typeSig.length() >= 2 && typeSig.startsWith("[") && PackageFinder.isPrimitiveTypeSignature(typeSig.substring(1, typeSig.length()))) {
            return true;
        }
        if (typeSig.length() != 1) {
            return false;
        }
        return typeSig.equals("V") || typeSig.equals("Z") || typeSig.equals("B") || typeSig.equals("C") || typeSig.equals("D") || typeSig.equals("F") || typeSig.equals("I") || typeSig.equals("J") || typeSig.equals("S");
    }

    static String extractFullyQualifiedTopLevelType(String typeName) {
        int innerClassIndicator = (typeName = typeName.replace('/', '.')).indexOf(36);
        typeName = innerClassIndicator > 0 ? typeName.substring(0, innerClassIndicator).concat(";") : typeName;
        typeName = Signature.toString((String)typeName);
        typeName = typeName.endsWith("[]") ? typeName.substring(0, typeName.length() - 2) : typeName;
        return typeName;
    }

    static String getPackage(String classType) {
        int period = classType.lastIndexOf(46);
        return period == -1 ? "" : classType.substring(0, period);
    }

    public static IClassFile[] getClassFiles(IProject project, IBundlePluginModelBase base) {
        ArrayList<IClassFile> classFiles = new ArrayList<IClassFile>();
        IBundle bundle = base.getBundleModel().getBundle();
        String value = bundle.getHeader("Bundle-ClassPath");
        if (value == null) {
            value = ".";
        }
        ManifestElement[] elems = null;
        try {
            elems = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)value);
        }
        catch (BundleException e) {
            return new IClassFile[0];
        }
        ManifestElement[] manifestElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement elem = manifestElementArray[n2];
            String lib = elem.getValue();
            IResource res = project.findMember(lib);
            if (res != null) {
                PackageFinder.addClassFilesFromResource(res, classFiles);
            }
            ++n2;
        }
        return classFiles.toArray(new IClassFile[classFiles.size()]);
    }

    private static void addClassFilesFromResource(IResource res, List<IClassFile> classFiles) {
        if (res == null) {
            return;
        }
        ArrayDeque<IResource> stack = new ArrayDeque<IResource>();
        if (res instanceof IContainer) {
            stack.push(res);
            while (!stack.isEmpty()) {
                try {
                    IResource[] children;
                    IResource[] iResourceArray = children = ((IContainer)stack.pop()).members();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource child = iResourceArray[n2];
                        if (child instanceof IFile && "class".equals(child.getFileExtension())) {
                            classFiles.add(JavaCore.createClassFileFrom((IFile)((IFile)child)));
                        } else if (child instanceof IContainer) {
                            stack.push(child);
                        }
                        ++n2;
                    }
                }
                catch (CoreException children) {
                    // empty catch block
                }
            }
        } else if (res instanceof IFile) {
            if (res.getFileExtension().equals("jar") || res.getFileExtension().equals("zip")) {
                IPackageFragmentRoot root = JavaCore.create((IProject)res.getProject()).getPackageFragmentRoot(res);
                if (root == null) {
                    return;
                }
                try {
                    IJavaElement[] children;
                    IJavaElement[] iJavaElementArray = children = root.getChildren();
                    int n = children.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IJavaElement child = iJavaElementArray[n3];
                        if (child instanceof IPackageFragment) {
                            IPackageFragment frag = (IPackageFragment)child;
                            IClassFile[] files = frag.getClassFiles();
                            Collections.addAll(classFiles, files);
                        }
                        ++n3;
                    }
                }
                catch (JavaModelException javaModelException) {}
            } else if (res.getFileExtension().equals("class")) {
                JavaCore.createClassFileFrom((IFile)((IFile)res));
            }
        }
    }
}

