/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.imagebrowser.repositories;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.SequencedMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.views.imagebrowser.IImageTarget;
import org.eclipse.pde.internal.ui.views.imagebrowser.ImageElement;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;

public abstract class AbstractRepository
extends Job {
    private final SequencedMap<String, ImageElement> mElementsCache = new LinkedHashMap<String, ImageElement>();
    private final IImageTarget mTarget;
    private static final String[] KNOWN_EXTENSIONS = new String[]{".gif", ".png", ".svg"};

    public AbstractRepository(IImageTarget target) {
        super(PDEUIMessages.AbstractRepository_ScanForUI);
        this.mTarget = target;
    }

    protected synchronized IStatus run(IProgressMonitor monitor) {
        while (this.mTarget.needsMore() && !monitor.isCanceled()) {
            if (this.mElementsCache.isEmpty()) {
                if (this.populateCache(monitor)) continue;
                return Status.OK_STATUS;
            }
            this.mTarget.notifyImage(this.mElementsCache.sequencedValues().removeFirst());
        }
        return Status.OK_STATUS;
    }

    public synchronized void clearCache() {
        if (this.mElementsCache != null) {
            this.mElementsCache.clear();
        }
    }

    public ImageElement getImageElement(String key) {
        return (ImageElement)this.mElementsCache.get(key);
    }

    protected abstract boolean populateCache(IProgressMonitor var1);

    protected ImageData createImageData(IFile file) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream s = new BufferedInputStream(file.getContents());){
                return new ImageData((InputStream)s);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)("Failed to close stream on: " + String.valueOf(file.getLocation())), (Throwable)e));
        }
    }

    protected ImageData createImageData(File file) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream s = new BufferedInputStream(new FileInputStream(file));){
                return new ImageData((InputStream)s);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)("Failed to close stream on: " + file.getAbsolutePath()), (Throwable)e));
        }
    }

    /*
     * Loose catch block
     */
    protected ImageData createImageData(File jarFile, ZipEntry entry) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(jarFile);){
                ImageData imageData;
                InputStream inputStream;
                Throwable throwable2;
                block23: {
                    throwable2 = null;
                    Object var7_12 = null;
                    inputStream = zipFile.getInputStream(entry);
                    imageData = new ImageData(inputStream);
                    if (inputStream == null) break block23;
                    inputStream.close();
                }
                return imageData;
                {
                    catch (Throwable throwable3) {
                        try {
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                        catch (SWTException e) {
                            throw new CoreException(Status.error((String)NLS.bind((String)PDEUIMessages.AbstractRepository_ErrorLoadingImageFromJar, (Object)jarFile.getAbsolutePath(), (Object)entry.getName()), (Throwable)e));
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)("Failed to close stream on: " + jarFile.getAbsolutePath()), (Throwable)e));
        }
    }

    protected boolean isImage(File resource) {
        if (resource.isFile()) {
            return this.isImageName(resource.getName());
        }
        return false;
    }

    protected boolean isImageName(String fileName) {
        String[] stringArray = KNOWN_EXTENSIONS;
        int n = KNOWN_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (fileName.regionMatches(true, fileName.length() - extension.length(), extension, 0, extension.length())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isJar(File file) {
        return file.getName().toLowerCase().endsWith(".jar");
    }

    protected void searchJarFile(File jarFile, IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(jarFile);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements() && !monitor.isCanceled()) {
                    ZipEntry entry = entries.nextElement();
                    if (!this.isImageName(entry.getName())) continue;
                    this.addImageElement(new ImageElement(() -> this.createImageData(jarFile, entry), jarFile.getName(), entry.getName()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDEPlugin.log(e);
        }
    }

    protected void searchDirectory(File directory, IProgressMonitor monitor) {
        File manifest = new File(directory, "META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            try {
                Optional<String> name = this.getPluginName(new FileInputStream(manifest));
                if (!name.isPresent()) {
                    return;
                }
                String pluginName = name.get();
                int directoryPathLength = directory.getAbsolutePath().length();
                HashSet<File> locations = new HashSet<File>();
                locations.add(directory);
                do {
                    File next = (File)locations.iterator().next();
                    locations.remove(next);
                    File[] fileArray = next.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File resource = fileArray[n2];
                        if (monitor.isCanceled()) {
                            return;
                        }
                        if (resource.isDirectory()) {
                            locations.add(resource);
                        } else if (this.isImage(resource)) {
                            this.addImageElement(new ImageElement(() -> this.createImageData(resource), pluginName, resource.getAbsolutePath().substring(directoryPathLength)));
                        }
                        ++n2;
                    }
                } while (!locations.isEmpty() && !monitor.isCanceled());
            }
            catch (IOException e) {
                PDEPlugin.log(e);
            }
        }
    }

    protected Optional<String> getPluginName(InputStream manifest) throws IOException {
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream stream = new BufferedInputStream(manifest);){
            properties.load(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String property = properties.getProperty("Bundle-SymbolicName");
        if (property == null) {
            return Optional.empty();
        }
        if (property.contains(";")) {
            return Optional.of(property.substring(0, property.indexOf(59)).trim());
        }
        return Optional.of(property.trim());
    }

    protected void addImageElement(ImageElement element) {
        this.mElementsCache.put(element.getPath(), element);
    }
}

