/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.communication;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;

public class RemoteFileStorage
extends PlatformObject
implements IEncodedStorage {
    private byte[] content;
    private String fileName;
    private String originalURL;

    public RemoteFileStorage(byte[] content, String fileName, String originalURL) {
        this.content = content;
        this.fileName = fileName;
        this.originalURL = originalURL;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getOriginalURL() {
        return this.originalURL;
    }

    public InputStream getContents() throws CoreException {
        return new ByteArrayInputStream(this.content);
    }

    public IPath getFullPath() {
        return Path.fromPortableString((String)this.fileName);
    }

    public String getName() {
        if (VirtualPath.isAbsolute(this.fileName)) {
            return new VirtualPath(this.fileName).getLastSegment();
        }
        return this.fileName;
    }

    public boolean isReadOnly() {
        return true;
    }

    public String getCharset() throws CoreException {
        return null;
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteFileStorage) {
            return ((RemoteFileStorage)((Object)obj)).fileName.equals(this.fileName);
        }
        return super.equals(obj);
    }
}

