/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.parameters;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.debug.core.debugger.parameters.IWebDebugParametersInitializer;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunch;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.core.zend.debugger.parameters.AbstractDebugParametersInitializer;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public class DefaultDebugParametersInitializer
extends AbstractDebugParametersInitializer
implements IWebDebugParametersInitializer {
    public static final String USE_SSL = "use_ssl";
    public static final String CODE_COVERAGE = "debug_coverage";
    public static final String DEBUG_NO_REMOTE = "no_remote";
    public static final String DEBUG_USE_REMOTE = "use_remote";
    public static final String DEBUG_FASTFILE = "debug_fastfile";
    public static final String START_PROFILE = "start_profile";
    public static final String GET_FILE_CONTENT = "get_file_content";
    public static final String LINE_NUMBER = "line_number";
    public static final String IS_DEBUG_URL = "isDebugURL";
    public static final String IS_PROFILE_URL = "isProfileURL";
    public static final String DEBUG_LINE_BP = "debug_line_bp";

    @Override
    public Hashtable<String, String> getDebugParameters(ILaunch launch) {
        boolean useSSL;
        String codeCoverageFlag;
        Hashtable<String, String> parameters;
        block29: {
            String sessID;
            String url;
            parameters = new Hashtable<String, String>();
            if (launch instanceof XDebugLaunch) {
                return parameters;
            }
            ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
            parameters.put("start_debug", "1");
            String port = launch.getAttribute("port");
            if (port != null) {
                parameters.put("debug_port", port);
            } else {
                PHPDebugPlugin.logErrorMessage("A port was not defined for the DefaultDebugParametersInitializer.");
            }
            if (this.getBooleanValue(launch.getAttribute("passiveDebug"))) {
                parameters.put("debug_passive", "1");
            }
            parameters.put("send_sess_end", "1");
            if (this.getBooleanValue(launch.getAttribute("webServerDebugger"))) {
                String debugHosts = PHPDebugPlugin.getDebugHosts();
                if (launchConfiguration != null) {
                    try {
                        Server server = ServersManager.getServer((String)launchConfiguration.getAttribute("name", ""));
                        String customHosts = ZendDebuggerSettingsUtil.getDebugHosts(server.getUniqueId());
                        if (!customHosts.isEmpty()) {
                            debugHosts = customHosts;
                        }
                    }
                    catch (CoreException ce) {
                        Logger.logException(ce);
                    }
                }
                parameters.put("debug_host", debugHosts);
                parameters.put("debug_no_cache", Long.toString(System.currentTimeMillis()));
            }
            if ("debug".equals(launch.getLaunchMode()) && this.getBooleanValue(launch.getAttribute("firstLineBreakpoint"))) {
                parameters.put("debug_stop", "1");
            }
            if ((url = launch.getAttribute("uriginalURL")) != null) {
                parameters.put("original_url", url);
            }
            if (launchConfiguration != null) {
                try {
                    String sessionSetting = launchConfiguration.getAttribute("debugPages", "debugAllPages");
                    if ("debugAllPages".equals(sessionSetting)) {
                        parameters.put("debug_start_session", "1");
                    } else if ("debugFirstPage".equals(sessionSetting)) {
                        parameters.put("debug_new_session", "1");
                    } else if ("debugFrom".equals(sessionSetting)) {
                        parameters.put("debug_start_url", launchConfiguration.getAttribute("debugContinue", ""));
                        if (launchConfiguration.getAttribute("debugFromURL", false)) {
                            parameters.put("debug_cont_session", "1");
                        }
                    }
                }
                catch (CoreException ce) {
                    Logger.logException(ce);
                }
            }
            if ((sessID = launch.getAttribute("debugSessionID")) != null) {
                parameters.put("debug_session_id", sessID);
            }
            parameters.put("ZRayDisable", "1");
            String isExecutableLaunch = launch.getAttribute("executable_launch");
            if (isExecutableLaunch == null || !Boolean.valueOf(isExecutableLaunch).booleanValue()) {
                if (launchConfiguration != null) {
                    try {
                        if (launchConfiguration.getAttribute("debugNoRemote", false)) {
                            parameters.put(DEBUG_NO_REMOTE, "1");
                            break block29;
                        }
                        parameters.put(DEBUG_USE_REMOTE, "1");
                    }
                    catch (CoreException coreException) {}
                }
            } else {
                parameters.put(DEBUG_USE_REMOTE, "1");
            }
        }
        if ((codeCoverageFlag = launch.getAttribute("collectCodeCoverage")) != null && Integer.parseInt(codeCoverageFlag) > 0) {
            parameters.put(CODE_COVERAGE, codeCoverageFlag);
        }
        if (useSSL = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").getBoolean("zend_debug_use_ssl_encryption", false)) {
            parameters.put(USE_SSL, "1");
        }
        parameters.put(DEBUG_FASTFILE, "1");
        return parameters;
    }

    @Override
    public URL getRequestURL(ILaunch launch) {
        String url = launch.getAttribute("uriginalURL");
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            Logger.logException("Malformed URL: " + url, e);
            return null;
        }
    }

    public boolean getBooleanValue(String value) {
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    @Override
    public Hashtable<String, String> getRequestCookies(ILaunch launch) {
        return null;
    }

    @Override
    public Hashtable<String, String> getRequestHeaders(ILaunch launch) {
        return null;
    }

    @Override
    public String getRequestMethod(ILaunch launch) {
        return null;
    }

    @Override
    public Hashtable<String, String> getRequestParameters(ILaunch launch) {
        return null;
    }

    @Override
    public String getRequestRawData(ILaunch launch) {
        return null;
    }
}

