/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.model.SimpleDebugHandler;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnection;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.StartLock;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public class ServerDebugHandler
extends SimpleDebugHandler {
    protected IRemoteDebugger fRemoteDebugger;
    protected boolean fStatus;
    protected PHPDebugTarget fDebugTarget;
    protected DebugConnection fDebugConnection;
    protected boolean fCodeCoverage;
    protected boolean fUseLocalCopy;
    protected CodeCoverageData[] fCodeCoverageData;

    @Override
    public IRemoteDebugger getRemoteDebugger() {
        return this.fRemoteDebugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionStarted(String remoteFile, String uri, String query, String options) {
        StartLock startLock;
        ILaunchConfiguration iLaunchConfiguration;
        ILaunchConfigurationWorkingCopy wc;
        Server serverLookup;
        String serverName;
        super.sessionStarted(remoteFile, uri, query, options);
        this.fUseLocalCopy = true;
        ILaunchConfiguration launchConfiguration = this.fDebugTarget.getLaunch().getLaunchConfiguration();
        try {
            this.fUseLocalCopy = !launchConfiguration.getAttribute("debugNoRemote", false);
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
        }
        if (this.fUseLocalCopy) {
            block36: {
                String serverURL = this.fDebugTarget.getURL();
                if (serverURL != null) {
                    try {
                        serverName = null;
                        serverLookup = ServersManager.findByURL((String)serverURL);
                        if (serverLookup != null) {
                            serverName = serverLookup.getName();
                        }
                        if (serverName == null) break block36;
                        wc = launchConfiguration.getWorkingCopy();
                        wc.setAttribute("name", serverName);
                        iLaunchConfiguration = launchConfiguration;
                        synchronized (iLaunchConfiguration) {
                            wc.doSave();
                        }
                    }
                    catch (CoreException e) {
                        DebugPlugin.log((Throwable)e);
                    }
                }
            }
            try {
                String debugType = launchConfiguration.getAttribute("php_debug_type", "");
                if (debugType.equals("php_web_script_debug")) {
                    PathMapper pathMapper = PathMapperRegistry.getByLaunchConfiguration(launchConfiguration);
                    String debugFilePath = launchConfiguration.getAttribute("ATTR_FILE", null);
                    String debugFileFullPath = launchConfiguration.getAttribute("ATTR_FILE_FULL_PATH", null);
                    if (pathMapper != null && debugFilePath != null && debugFileFullPath != null && pathMapper.getLocalFile(debugFileFullPath) == null) {
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(debugFilePath);
                        if (resource instanceof IFile) {
                            pathMapper.addEntry(debugFileFullPath, new PathEntry(debugFilePath, PathEntry.Type.WORKSPACE, (Object)resource.getParent()), PathMapper.Mapping.MappingSource.ENVIRONMENT);
                        } else if (new File(debugFilePath).exists()) {
                            pathMapper.addEntry(debugFilePath, new PathEntry(debugFilePath, PathEntry.Type.EXTERNAL, (Object)new File(debugFilePath).getParentFile()), PathMapper.Mapping.MappingSource.ENVIRONMENT);
                        }
                    }
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        if (this.isUsingPathMapper()) {
            block37: {
                try {
                    String lcServerName = launchConfiguration.getAttribute("name", null);
                    if (lcServerName != null && !lcServerName.isEmpty() || this.fDebugTarget.getURL() == null) break block37;
                    serverName = null;
                    serverLookup = ServersManager.findByURL((String)this.fDebugTarget.getURL());
                    if (serverLookup != null) {
                        serverName = serverLookup.getName();
                    }
                    if (serverName == null) break block37;
                    wc = launchConfiguration.getWorkingCopy();
                    wc.setAttribute("name", serverName);
                    iLaunchConfiguration = launchConfiguration;
                    synchronized (iLaunchConfiguration) {
                        wc.doSave();
                    }
                }
                catch (CoreException e) {
                    DebugPlugin.log((Throwable)e);
                }
            }
            try {
                File file = new File(remoteFile);
                if (file.exists()) {
                    remoteFile = file.getCanonicalPath();
                }
            }
            catch (Exception file) {
                // empty catch block
            }
            this.fDebugTarget.mapFirstDebugFile(remoteFile);
        }
        this.fDebugTarget.setLastFileName(remoteFile);
        if (!this.fDebugTarget.isPHPCGI()) {
            this.fDebugTarget.setServerWindows(false);
        }
        StartLock startLock2 = startLock = this.fDebugTarget.getStartLock();
        synchronized (startLock2) {
            if (startLock.isRunStart()) {
                startLock.setStarted(true);
                this.fDebugTarget.started();
                this.fStatus = this.getRemoteDebugger().start(this.fDebugTarget.getStartResponseHandler());
                if (!this.fStatus) {
                    Logger.log(4, "ServerDebugHandler: debugger.start return false");
                    try {
                        this.fDebugTarget.disconnect();
                    }
                    catch (DebugException e) {
                        Logger.logException(e);
                    }
                }
                this.fDebugTarget.setLastCommand("start");
            } else {
                startLock.setRunStart(true);
            }
        }
        this.fCodeCoverage = query.indexOf("debug_coverage") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionEstablished() {
        StartLock startLock;
        super.connectionEstablished();
        StartLock startLock2 = startLock = this.fDebugTarget.getStartLock();
        synchronized (startLock2) {
            if (startLock.isRunStart()) {
                startLock.setStarted(true);
                this.fDebugTarget.started();
                this.fStatus = this.getRemoteDebugger().start(this.fDebugTarget.getStartResponseHandler());
                if (!this.fStatus) {
                    Logger.log(4, "ServerDebugHandler: debugger.start return false");
                }
                this.fDebugTarget.setLastCommand("start");
            } else {
                startLock.setRunStart(true);
            }
        }
    }

    @Override
    public void ready(String fileName, int lineNumber) {
        super.ready(fileName, lineNumber);
        this.fDebugTarget.setLastStop(lineNumber);
        this.fDebugTarget.setLastFileName(fileName);
        String fLastcmd = this.fDebugTarget.getLastCommand();
        Logger.debugMSG("ServerDebugHandler: lastCMD " + fLastcmd);
        this.fDebugTarget.setBreakpoints(new IBreakpoint[0]);
        ILaunchConfiguration launchConfiguration = this.fDebugTarget.getLaunch().getLaunchConfiguration();
        try {
            this.fDebugTarget.setExpressionManager(new DefaultExpressionsManager(this.fRemoteDebugger, launchConfiguration.getAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(null))));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (fLastcmd.equals("start")) {
            this.fDebugTarget.breakpointHit(this.fDebugTarget.getLastFileName(), lineNumber);
        } else if (fLastcmd.equals("resume")) {
            this.fDebugTarget.breakpointHit(this.fDebugTarget.getLastFileName(), lineNumber);
        } else if (fLastcmd.equals("suspend")) {
            this.fDebugTarget.suspended(32);
        } else if (fLastcmd.equals("stepReturn")) {
            this.fDebugTarget.suspended(4);
        } else if (fLastcmd.equals("stepOver")) {
            this.fDebugTarget.suspended(2);
        } else if (fLastcmd.equals("stepInto")) {
            this.fDebugTarget.suspended(1);
        } else if (fLastcmd.equals("terminate")) {
            this.fRemoteDebugger.finish();
            this.fDebugTarget.terminated();
        } else if (!fLastcmd.equals("breakpointAdded")) {
            fLastcmd.equals("breakpointRemoved");
        }
    }

    @Override
    public void sessionEnded() {
        Logger.debugMSG("ServerDebugHandler: Starting sessionEnded()");
        super.sessionEnded();
    }

    @Override
    public void connectionClosed() {
        Logger.debugMSG("ServerDebugHandler: Starting connectionClosed()");
        super.connectionClosed();
        this.fRemoteDebugger.finish();
        Logger.debugMSG("ServerDebugHandler: Calling Terminated()");
        this.fDebugTarget.terminated();
    }

    @Override
    public void handleScriptEnded() {
        try {
            IRemoteDebugger remoteDebugger;
            if (this.fCodeCoverage && (remoteDebugger = this.getRemoteDebugger()) instanceof RemoteDebugger) {
                this.fCodeCoverageData = ((RemoteDebugger)remoteDebugger).getCodeCoverageData();
            }
        }
        finally {
            Logger.debugMSG("ServerDebugHandler: handleScriptEnded");
            try {
                Logger.debugMSG("ServerDebugHandler: Calling Terminate()");
                this.fDebugTarget.terminate();
            }
            catch (DebugException e1) {
                Logger.logException("ServerDebugHandler: terminate failed", e1);
            }
        }
    }

    @Override
    public void multipleBindOccured() {
        super.multipleBindOccured();
        Logger.log(2, "ServerDebugHandler: Multiple Bind Occured");
        String errorMessage = PHPDebugCoreMessages.DebuggerDebugPortInUse_1;
        this.fRemoteDebugger.closeConnection();
        this.fDebugTarget.fireError(errorMessage, null);
        this.fDebugTarget.terminated();
    }

    @Override
    public void parsingErrorOccured(DebugError debugError) {
        super.parsingErrorOccured(debugError);
        String localFileName = ((RemoteDebugger)this.fRemoteDebugger).convertToLocalFilename(debugError.getFullPathName(), null, null);
        if (localFileName == null) {
            localFileName = debugError.getFullPathName();
        }
        debugError.setFileName(localFileName);
        if (this.fDebugTarget.getDebugErrors().add(debugError)) {
            Object[] listeners;
            Object[] objectArray = listeners = this.fDebugTarget.getConsoleEventListeners().toArray();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                ((IPHPConsoleEventListener)element).handleEvent(debugError);
                ++n2;
            }
        }
    }

    @Override
    public void wrongDebugServer() {
        super.wrongDebugServer();
        this.fDebugTarget.fireError(PHPDebugCoreMessages.ServerDebugHandler_0, null);
        this.fRemoteDebugger.finish();
    }

    @Override
    public void newOutput(String output) {
        super.newOutput(output);
        this.fDebugTarget.getOutputBuffer().append(output);
    }

    @Override
    public void newHeaderOutput(String output) {
        super.newHeaderOutput(output);
        this.fDebugTarget.getOutputBuffer().appendHeader(output);
    }

    @Override
    public void setDebugTarget(PHPDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
        this.fDebugConnection = this.fDebugTarget.getDebugConnection();
        this.fRemoteDebugger = this.createRemoteDebugger();
        this.fDebugConnection.getCommunicationAdministrator().connectionEstablished();
    }

    @Override
    public PHPDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public CodeCoverageData[] getLastCodeCoverageData() {
        return this.fCodeCoverageData;
    }

    protected IRemoteDebugger createRemoteDebugger() {
        return new RemoteDebugger(this, this.fDebugConnection);
    }

    protected boolean isUsingPathMapper() {
        return this.fUseLocalCopy;
    }
}

