/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ProblemsLabelDecorator;
import org.eclipse.dltk.ui.viewsupport.IProblemChangedListener;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class PHPEditorErrorTickUpdater
implements IProblemChangedListener {
    private PHPStructuredEditor fPHPEditor;
    private ScriptUILabelProvider fLabelProvider;

    public PHPEditorErrorTickUpdater(PHPStructuredEditor editor) {
        Assert.isNotNull((Object)((Object)editor));
        this.fPHPEditor = editor;
        this.fLabelProvider = new ScriptUILabelProvider(0L, 2);
        this.fLabelProvider.addLabelDecorator((ILabelDecorator)new ProblemsLabelDecorator(null));
        DLTKUIPlugin.getDefault().getProblemMarkerManager().addListener((IProblemChangedListener)this);
    }

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        IModelElement element;
        if (!isMarkerChange) {
            return;
        }
        IEditorInput input = this.fPHPEditor.getEditorInput();
        if (input != null && (element = (IModelElement)input.getAdapter(IModelElement.class)) != null) {
            IResource resource = element.getResource();
            int i = 0;
            while (i < changedResources.length) {
                if (changedResources[i].equals((Object)resource)) {
                    this.updateEditorImage(element);
                }
                ++i;
            }
        }
    }

    public void updateEditorImage(IModelElement element) {
        Image titleImage = this.fPHPEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image newImage = element instanceof ISourceModule && !element.getScriptProject().isOnBuildpath(element) ? this.fLabelProvider.getImage((Object)element.getResource()) : this.fLabelProvider.getImage((Object)element);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(Image newImage) {
        Shell shell = this.fPHPEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(() -> this.fPHPEditor.updatedTitleImage(newImage));
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        DLTKUIPlugin.getDefault().getProblemMarkerManager().removeListener((IProblemChangedListener)this);
    }
}

